<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.4.0
 */

use \Directorist\Helper;
use wpWax\dLawyers\Theme;

$columns = floor( 12 / $taxonomy->columns );
$show_title = isset( Theme::$options['show_all_categories_title'] ) ? Theme::$options['show_all_categories_title'] : false;
$title_1 = isset( Theme::$options['all_categories_title_text_1'] ) ? Theme::$options['all_categories_title_text_1'] : '';
$title_2 = isset( Theme::$options['all_categories_title_text_2'] ) ? Theme::$options['all_categories_title_text_2'] : '';
?>
<div id="directorist" class="atbd_wrapper directorist-w-100">
	<?php
	/**
	 * @since 5.6.6
	 */
	do_action( 'atbdp_before_all_categories_loop', $taxonomy );
	?>
	<div class="<?php Helper::directorist_container_fluid(); ?>">

		<?php if( get_the_ID() == get_directorist_option('all_categories_page') && $show_title ): ?>

			<?php printf('<h1 class="theme-category-title"> %s <strong>%s</strong></h1>', esc_html( $title_1 ), esc_html( $title_2 ) ); ?>

		<?php endif; ?>

		<div class="atbd_all_categories">
			<div class="<?php Helper::directorist_row(); ?>">
				<?php
				if( $categories ) {
					foreach ($categories as $category) {
						$cat_class = !$category['img'] ? ' atbd_category_no_image' : '';
						?>
						<div class="<?php Helper::directorist_column( $columns ); ?>">
							<a class="atbd_category_single<?php echo esc_attr( $cat_class ); ?>" href="<?php echo esc_url($category['permalink']); ?>">
								<figure>
									<?php if ( $category['img'] ) { ?>
										<img src="<?php echo esc_url( $category['img'] ); ?>" title="<?php echo esc_attr($category['name']); ?>" alt="<?php echo esc_attr($category['name']); ?>">
										<?php
									}
									?>
									<figcaption class="overlay-bg">
										<div class="cat-box">
											<?php
												if ($category['has_icon']) { ?>
													<div class="icon">
														<?php directorist_icon( esc_attr( $category['icon_class'] ) ); ?>
													</div>
													<?php
												}
												?>
												<div class="cat-info">
													<h4 class="cat-name"><?php echo esc_html($category['name']); ?></h4>
													<?php if( $taxonomy->show_count ){ ?>
													<span class="cat-count">
														<?php echo wp_kses_post( apply_filters( 'dlawyers_directorist_grid_count_html', $category['grid_count_html'] ) ); ?> <span><?php echo wp_kses_post( ( ( $category['term']->count > 1 ) || ( $category['term']->count == 0 ) ) ? esc_html__( 'listings', 'dlawyers' ) : esc_html__( 'listing', 'dlawyers' ) ); ?></span>
													</span>
													<?php } ?>
												</div>
										</div>
									</figcaption>
								</figure>
							</a>
						</div>
						<?php
					}
				} else {
					?>
					<p><?php esc_html_e( 'No Results found!', 'dlawyers' ); ?></p>
					<?php
				}
				?>
			</div>
		</div>
	</div>

	<?php
    /**
     * @since 5.6.6
     */
    do_action( 'atbdp_after_all_categories_loop' );
    ?>
</div>