<?php
/**
 * @author  wpWax
 * @since   6.6
 * @version 7.3.1
 */

use \Directorist\Helper;
use wpWax\dLawyers\Theme;

$columns = floor( 12 / $taxonomy->columns );
$show_title = isset( Theme::$options['show_all_locations_title'] ) ? Theme::$options['show_all_locations_title'] : false;
$title_1 = isset( Theme::$options['all_locations_title_text_1'] ) ? Theme::$options['all_locations_title_text_1'] : '';
$title_2 = isset( Theme::$options['all_locations_title_text_2'] ) ? Theme::$options['all_locations_title_text_2'] : '';
?>
<div id="directorist" class="atbd_wrapper directorist-w-100">

	<div class="<?php Helper::directorist_container_fluid(); ?>">

		<?php if( get_the_ID() == get_directorist_option('all_locations_page') && $show_title ): ?>

			<?php printf('<h1 class="location-title"> %s <strong>%s</strong></h1>', esc_html( $title_1 ), esc_html( $title_2 ) ); ?>

		<?php endif; ?>

		<?php
		/**
		 * @since 5.6.6
		 */
		do_action( 'atbdp_before_all_locations_loop', $taxonomy );
		?>
		<div class="atbd_location_grid_wrap atbdp-no-margin">
			<div class="<?php Helper::directorist_row(); ?>">
				<?php
				if( $locations ) {
					foreach ($locations as $key => $location) {
						$loc_class = $location['img'] ? '' : ' atbd_location_grid-default';
						
						$col_key = apply_filters( 'dlawyers_directorist_column_key', array(
							'key' => $key,
							'columns' => $columns,
						));
						?>
						<div class="<?php Helper::directorist_column( $col_key['columns'] ); ?>">

							<a class="atbd_location_grid<?php echo esc_attr( $loc_class ); ?>" href="<?php echo esc_url($location['permalink']); ?>">
								<figure>
									<?php if ($location['img']) { ?>
										<img src="<?php echo esc_url( $location['img'] ); ?>" title="<?php echo esc_attr($location['name']); ?>" alt="<?php echo esc_attr($location['name']); ?>">
										<?php
									}
									?>
									<figcaption>
										<h3><?php echo esc_html($location['name']); ?></h3>
										<?php echo wp_kses_post( apply_filters( 'dlawyers_directorist_grid_count_html', $location['grid_count_html'] ) ); ?>
									</figcaption>
								</figure>
							</a>

						</div>
						<?php
					}
				}
				else {
					?>
					<p><?php esc_html_e( 'No Results found!', 'dlawyers' ); ?></p>
					<?php
				}
				?>
			</div>
		</div>
	</div>
	<?php
	/**
     * @since 5.6.6
     */
    do_action( 'atbdp_after_all_locations_loop' );
    ?>
</div>