<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;


if ( ! isset( $content_width ) ) {
	$content_width = 1140;
}

class dLawyers_Main {

	public $theme = 'dlawyers';

	public function __construct() {
		add_action( 'after_setup_theme', array( $this, 'load_textdomain' ) );
		$this->includes();
	}

	public function load_textdomain() {
		load_theme_textdomain( $this->theme, get_template_directory() . '/languages' );
	}

	public function includes() {

		require_once get_template_directory() . '/core/core.php';

		do_action( 'dlawyers_theme_init_before' );

		require_once get_template_directory() . '/lib/wpwaxtheme-breadcrumb/breadcrumb.php';
		require_once get_template_directory() . '/lib/tgm/class-tgm-plugin-activation.php';
		require_once get_template_directory() . '/lib/directorist-theme-updater/theme-updater-admin.php';

		require_once get_template_directory() . '/inc/constants.php';
		require_once get_template_directory() . '/inc/traits/init.php';
		require_once get_template_directory() . '/inc/helper.php';
		// require_once get_template_directory() . '/inc/class-helper.php';
		require_once get_template_directory() . '/inc/tgm-config.php';
		require_once get_template_directory() . '/inc/updater-config.php';

		require_once get_template_directory() . '/inc/options/init.php';
		require_once get_template_directory() . '/inc/metabox.php';

		require_once get_template_directory() . '/inc/theme.php';
		require_once get_template_directory() . '/inc/general.php';
		require_once get_template_directory() . '/inc/scripts.php';
		require_once get_template_directory() . '/inc/layout-settings.php';

		require_once get_template_directory() . '/inc/directorist-notice.php';

		if ( class_exists( 'Directorist_Base' ) ) {
			require_once get_template_directory() . '/inc/directorist-support.php';
			require_once get_template_directory() . '/migration/class-migration-v8.php';
		}

		do_action( 'dlawyers_theme_init_after' );
	}
}

new dLawyers_Main;
