<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class wpWax_Theme_Ext_Notice {

	protected static $instance = null;

	public $notice_dissmiss_id = 'dlawyers_dismiss_ext_notice';

	private function __construct() {
		if ( ! is_admin() ) {
			return;
		}

		add_action( 'admin_notices', array( $this, 'admin_notice' ) );
		add_action( 'switch_theme', array( $this, 'delete_dismiss_info' ) );
		add_action( 'directorist_required_extensions', array( $this, 'required_extensions' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	public function get_extensions() {
		$plugins = array(
			array(
				'name' => 'Business Hours',
				'slug' => 'directorist-business-hours',
				'link' => 'https://directorist.com/product/directorist-business-hours/',
			),
			array(
				'name' => 'Listings with Map',
				'slug' => 'directorist-listings-with-map',
				'link' => 'https://directorist.com/product/directorist-listings-with-map/',
			),
			array(
				'name' => 'Social Login',
				'slug' => 'directorist-social-login',
				'link' => 'https://directorist.com/product/directorist-social-login/',
			),
			array(
				'name' => 'Pricing Plans',
				'slug' => 'directorist-pricing-plans',
				'link' => 'https://directorist.com/product/directorist-pricing-plans/',
			),
			array(
				'name' => 'Claim Listing',
				'slug' => 'directorist-claim-listing',
				'link' => 'https://directorist.com/product/directorist-claim-listing/',
			),
			array(
				'name' => 'Booking',
				'slug' => 'directorist-booking',
				'link' => 'https://directorist.com/product/directorist-booking/',
			),
		);

		return $plugins;
	}

	public function required_extensions( $required_extensions ) {
		$required_extensions = array();

		foreach ( $this->get_extensions() as $extension ) {
			$required_extensions[] = $extension['slug'];
		}

		$result[] = array(
			'ref'        => 'dlawyers',
			'extensions' => $required_extensions,
		);

		return $result;
	}

	public function delete_dismiss_info() {
		delete_user_meta( get_current_user_id(), $this->notice_dissmiss_id );
	}

	public function get_plugins() {
		// WP Cached
		if ( ! function_exists( 'get_plugins' ) ) {
			require_once ABSPATH . 'wp-admin/includes/plugin.php';
		}

		return get_plugins();
	}

	protected function plugin_basename( $slug ) {
		$keys = array_keys( $this->get_plugins() );

		foreach ( $keys as $key ) {
			if ( preg_match( '|^' . $slug . '/|', $key ) ) {
				return $key;
			}
		}

		return $slug;
	}

	public function is_plugin_installed( $slug ) {
		$path              = $this->plugin_basename( $slug );
		$installed_plugins = $this->get_plugins();

		return ( ! empty( $installed_plugins[$path] ) );
	}

	public function is_plugin_active( $slug ) {
		$path = $this->plugin_basename( $slug );

		return is_plugin_active( $path );
	}

	public function admin_notice() {
		if ( ! class_exists( 'Directorist_Base' ) ) {
			return;
		}

		if ( isset( $_GET['wpwx-theme-ext-dismiss'] ) ) {
			update_user_meta( get_current_user_id(), $this->notice_dissmiss_id, 1 );
		}

		if (  ( get_user_meta( get_current_user_id(), $this->notice_dissmiss_id, true ) ) ) {
			return;
		}

		$install = $active = array();

		foreach ( $this->get_extensions() as $plugin ) {
			if ( ! $this->is_plugin_installed( $plugin['slug'] ) ) {
				$install[] = sprintf( '<a target="_blank" href="%s">%s</a>', $plugin['link'], $plugin['name'] );
			} elseif ( ! $this->is_plugin_active( $plugin['slug'] ) ) {
				$active[] = sprintf( '<a target="_blank" href="%s">%s</a>', $plugin['link'], $plugin['name'] );
			}
		}

		if ( ! $install && ! $active ) {
			return;
		}

		$text = '';
		if ( $install ) {
			$text .= sprintf( __( '<p style="margin:2px 0;">This theme comes with the following Directorist Extensions which are currently uninstalled: %s</p>', 'dlawyers' ), implode( ', ', $install ) );
		}
		if ( $active ) {
			$text .= sprintf( __( '<p style="margin:2px 0;">This theme comes with the following Directorist Extensions which are currently inactive: %s</p>', 'dlawyers' ), implode( ', ', $active ) );
		}

		$link = admin_url( 'edit.php?post_type=at_biz_dir&page=atbdp-extension' );

		$text .= sprintf( __( '<p style="margin:2px 0;">You can manage, install or activate these extionsions from <a href="%s">here</a></p>', 'dlawyers' ), $link );

		$text .= sprintf( __( '<p style="margin:2px 0;"><a href="%1$s">Manage Directorist Extensions</a> | <a href="%2$s">Dismiss this notice permanently</a></p>', 'dlawyers' ), $link, add_query_arg( 'wpwx-theme-ext-dismiss', 1 ) );

		$notice = '<div class="notice notice-warning is-dismissible directorist-theme-updater-notice" style="font-weight:bold;padding-top: 5px;padding-bottom: 5px;">' . $text . '</div>';

		echo wp_kses_post( $notice );
	}
}

wpWax_Theme_Ext_Notice::instance();