<?php
/**
 *
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

use Directorist\Helper;
use wpWax\dLawyers\Helper as DHelper;

class Directorist_Support {

	use Directorist_Helper_Trait;

	protected static $instance = null;
	public static $searchform;
	public static $listing_DB;
	public static $listings_options;
	public static $listing_type;
	public static $theme_options;

	public function __construct() {

		Theme::instance()->set_options();

		// Adding & Modifying Builder Settings Fields for Grid & List View
		add_filter( 'atbdp_listing_type_settings_field_list', [ $this, 'atbdp_listing_type_settings_field_list' ] );
		// Removing Some Settings from Directorist Settings Panel
		add_filter( 'atbdp_listing_type_settings_layout', [ $this, 'atbdp_listing_type_settings_layout' ] );
		// Listing with Map
		//add_filter( 'bdmv_view_as', [ $this, 'bdmv_view_as' ] );

		// Adding and Modifying: Builder-> Single Page Layout -> Listing Header
		add_filter( 'directorist_listing_header_layout', [ $this, 'directorist_listing_header_layout' ] );
		// Adding New Sections: Builder-> Single Page Layout-> Contents
		add_filter( 'atbdp_single_listing_other_fields_widget', [ $this, 'atbdp_single_listing_other_fields_widget' ] );
		add_filter( 'atbdp_single_listing_content_widgets', [ $this, 'atbdp_single_listing_content_widgets' ] );
		add_filter( 'directorist_single_item_template', [ $this, 'directorist_single_item_template' ], 10, 2 );

		// Adding new Fields to Builder-> 'Add Listing/Submission Form'
		add_filter( 'atbdp_form_preset_widgets', [ $this, 'atbdp_form_preset_widgets' ] );
		add_filter( 'atbdp_form_custom_widgets', [ $this, 'atbdp_form_custom_widgets' ] );

		// Adding new fields to Builder-> Search Form
		add_filter( 'directorist_search_form_widgets', [ $this, 'directorist_search_form_widgets' ] );
		// Modifying Search Listings Meta Queries for Age Widget
		add_filter( 'atbdp_search_listings_meta_queries', [ $this, 'atbdp_search_listings_meta_queries' ] );

		// Adding new class in Dashboard
		add_filter( 'directorist_container_fluid', [ $this, 'directorist_container_fluid' ] );
		// Adding new class on Top Header in Dashboard
		add_filter( 'dlawyers_top_header_menu_area_class', [ $this, 'dlawyers_top_header_menu_area_class' ] );
		// Making "container-fluid" for dashboard
		add_filter( 'dlawyers_header_container_class', [ $this, 'dlawyers_header_container_class' ] );

		// Adding new Table Columns to Dashboard-> My Listings
		if (  ( isset( Theme::$options['dashboard_show_average_rating'] ) || isset( Theme::$options['dashboard_show_category'] ) ) && ( Theme::$options['dashboard_show_average_rating'] || Theme::$options['dashboard_show_category'] ) ) {
			add_action( 'directorist_dashboard_listing_th_2', [ $this, 'directorist_dashboard_listing_th_2' ] );
			add_action( 'directorist_dashboard_listing_td_2', [ $this, 'directorist_dashboard_listing_td_2' ], 10, 2 );
		}

		// Removing the 'directorist-inline-style' to prevent CSS conflict
		// add_filter( 'directorist_load_inline_style', '__return_false' );
		// For Header Search Form
		add_filter( 'directorist_js_scripts', [ $this, 'directorist_js_scripts' ] );
		// Adding "..." in excerpt
		add_filter( 'wp_trim_words', [ $this, 'wp_trim_words_filter' ], 10, 4 );
		// Adding Directorist Template Base Unique Class
		add_filter( 'body_class', [ $this, 'body_classes' ] );
		// Add contact button, login modal & header search popup HTML
		add_action( 'wp_body_open', [ $this, 'wp_body_open' ], 100 );

		// Admin Scripts for Listing Edit
		add_action( 'admin_footer', [ $this, 'dlawyers_admin_script' ] );
		add_action( 'directorist_pagination_prev_text', [ $this, 'all_listings_pagination_prev_text' ] );
		add_action( 'directorist_pagination_next_text', [ $this, 'all_listings_pagination_next_text' ] );
		// Fixed Textarea Bullet List issue
		add_filter( 'atbdp_ultimate_listing_meta_user_submission', [ $this, 'sanitize_listing_form_meta_fields' ], 10, 2 );
	}

	public static function instance() {

		if ( null === self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function directorist_container_fluid( $class ) {

		if ( atbdp_is_page( 'dashboard' ) ) {
			$class .= " dlawyers_user_dashboard ";
		}

		return $class;
	}

	public function atbdp_listing_type_settings_field_list( $fields ) {

		// Contact Popup Button for List & Grid View
		$dlawyers_contact_button = [
			'type'    => 'button',
			'id'      => 'dlawyers_contact_button',
			'label'   => esc_html__( "dLawyers: Contact Button", "dlawyers" ),
			'icon'    => 'uil uil-phone',
			'hook'    => 'atbdp_contact_button',
			'options' => [
				'title'  => esc_html__( "Button Label", "dlawyers" ),
				'fields' => [
					'value' => [
						'type'  => 'text',
						'label' => 'Contact Label',
						'value' => esc_html__( "Contact", "dlawyers" ),
					],
				],
			],
		];
		// Tag Widget for Grid View
		$tag = [
			'type'    => "category",
			'id'      => 'tag',
			'label'   => esc_html__( "dLawyers: Tag", "dlawyers" ),
			'icon'    => 'uil uil-text-fields',
			'hook'    => "atbdp_tag",
			'options' => [
				'title'  => esc_html__( "Tag Settings", "dlawyers" ),
				'fields' => [
					'value' => [
						'type'  => "text",
						'label' => esc_html__( "Tag Label", "dlawyers" ),
						'value' => esc_html__( "Tag", "dlawyers" ),
					],
				],
			],
		];
		// Free Consultation widget for List & Grid View
		$dlawyers_free_consultation = [
			'type'    => "button",
			'id'      => 'dlawyers_free_consultation',
			'label'   => esc_html__( "dLawyers: Free Consultation", "dlawyers" ),
			'icon'    => 'uil uil-check',
			'hook'    => "dlawyers_free_consultation",
			'options' => [
				'title'  => esc_html__( "Free Consultation Settings", "dlawyers" ),
				'fields' => [
					'value' => [
						'type'  => "text",
						'label' => esc_html__( "Free Consultation Label", "dlawyers" ),
						'value' => esc_html__( "Free Consultation", "dlawyers" ),
					],
					'icon'  => [
						'type'  => "icon",
						'label' => esc_html__( "Icon", "dlawyers" ),
						'value' => "uil uil-check",
					],
				],
			],
		];

		foreach ( $fields as $key => $value ) {

			if ( 'listings_card_grid_view' === $key ) {

				// Listing cart grid layout with thumbnail
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dlawyers_contact_button']    = $dlawyers_contact_button;
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dlawyers_free_consultation'] = $dlawyers_free_consultation;
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['tag']                        = $tag;

				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['thumbnail']['bottom_left']['acceptedWidgets'],
					'dlawyers_free_consultation' );
				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'rating' );
				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'website' );
				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'dlawyers_contact_button' );
				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['body']['top']['acceptedWidgets'],
					'tag' );

				// Listing cart grid layout without thumbnail
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dlawyers_contact_button']    = $dlawyers_contact_button;
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dlawyers_free_consultation'] = $dlawyers_free_consultation;
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['tag']                        = $tag;

				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'rating' );
				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'website' );
				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'dlawyers_contact_button' );
				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['body']['quick_info']['acceptedWidgets'],
					'tag' );
			}

			if ( 'listings_card_list_view' === $key ) {

				// Listing cart list layout with_thumbnail
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dlawyers_contact_button']    = $dlawyers_contact_button;
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dlawyers_free_consultation'] = $dlawyers_free_consultation;

				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'dlawyers_contact_button' );
				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'website' );
				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'rating' );
				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['right']['acceptedWidgets'],
					'excerpt' );

				// Listing cart list layout with_thumbnail
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dlawyers_contact_button']    = $dlawyers_contact_button;
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dlawyers_free_consultation'] = $dlawyers_free_consultation;

				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'dlawyers_contact_button' );
				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['right']['acceptedWidgets'],
					'website' );
				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'rating' );
				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['right']['acceptedWidgets'],
					'excerpt' );

			}
		}

		return $fields;
	}

	public function atbdp_listing_type_settings_layout( $fields ) {
		unset( $fields['style_settings']['submenu']['single_template'] );
		unset( $fields['style_settings']['submenu']['color_settings'] );

		return $fields;
	}

	public function bdmv_view_as( $html ) {
		$html = DHelper::get_template_part( 'directorist/custom/sort-map' );
		$html .= DHelper::get_template_part( 'directorist/custom/view-mode-map' );

		return $html;
	}

	public function wp_trim_words_filter( $text, $num_words, $more, $original_text ) {

		if ( 20 >= $num_words && get_post_type() === 'at_biz_dir' ) {
			$html = str_replace( '<a', '...<a', $text );

			return $html;
		} else {
			return $text;
		}
	}

	public function directorist_listing_header_layout( $fields ) {

		$title_fields = [
			'enable_title'             => [
				'type'  => "toggle",
				'label' => __( "Show Title", 'dlawyers' ),
				'value' => true,
			],
			'enable_tagline'           => [
				'type'  => "toggle",
				'label' => __( "Show Tagline", 'dlawyers' ),
				'value' => true,
			],
			'enable_gender'            => [
				'type'  => "toggle",
				'label' => esc_html__( "Show Gender", "dlawyers" ),
				'value' => true,
			],
			'enable_age'               => [
				'type'  => "toggle",
				'label' => esc_html__( "Show Age", "dlawyers" ),
				'value' => true,
			],
			'enable_reviews'           => [
				'type'  => "toggle",
				'label' => esc_html__( "Show Reviews", "dlawyers" ),
				'value' => true,
			],
			'enable_claim_listing'     => [
				'type'  => "toggle",
				'label' => esc_html__( "Show Claim Listing", "dlawyers" ),
				'value' => false,
			],
			'enable_consultation'      => [
				'type'  => "toggle",
				'label' => esc_html__( "Show Consultation", "dlawyers" ),
				'value' => false,
			],
			'enable_consultation_text' => [
				'type'  => "text",
				'label' => esc_html__( "Consultation Text", "dlawyers" ),
				'value' => "Free Consultation",
			],
		];

		$dlawyers_leave_a_review = [
			'type'    => "badge",
			'label'   => esc_html__( "Leave a review", "dlawyers" ),
			'icon'    => 'la la-share',
			'options' => [
				'title'  => esc_html__( "Leave a review Settings", "dlawyers" ),
				'fields' => [
					'icon' => [
						'type'  => "icon",
						'label' => esc_html__( "Icon", "dlawyers" ),
						'value' => 'la la-star',
					],
				],
			],
		];

		// Single Listing-> Header Right-> Leave_a_review
		$fields['widgets']['title']['options']['fields'] = $title_fields;
		$fields['widgets']['dlawyers_leave_a_review']    = $dlawyers_leave_a_review;

		return $fields;
	}

	public function atbdp_single_listing_other_fields_widget( $fields ) {
		$fields['dlawyers_description'] = [
			'type'    => 'section',
			'label'   => esc_html__( 'dLawyers: Description', 'dlawyers' ),
			'icon'    => 'la la-user',
			'options' => [
				'label'                => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Description', 'dlawyers' ),
				],
				'custom_block_id'      => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block ID', 'dlawyers' ),
					'value' => '',
				],
				'custom_block_classes' => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block Classes', 'dlawyers' ),
					'value' => '',
				],
			],
		];

		$fields['dlawyers_excerpt'] = [
			'type'    => 'section',
			'label'   => esc_html__( 'dLawyers: Excerpt', 'dlawyers' ),
			'icon'    => 'la la-user',
			'options' => [
				'label'                => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Excerpt', 'dlawyers' ),
				],
				'custom_block_id'      => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block ID', 'dlawyers' ),
					'value' => '',
				],
				'custom_block_classes' => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block Classes', 'dlawyers' ),
					'value' => '',
				],
			],
		];

		$fields['dlawyers_map'] = [
			'type'    => 'section',
			'label'   => esc_html__( 'dLawyers: Map', 'dlawyers' ),
			'icon'    => 'la la-map',
			'options' => [
				'label'                => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Location and Chambers', 'dlawyers' ),
				],
				'custom_block_id'      => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block ID', 'dlawyers' ),
					'value' => '',
				],
				'custom_block_classes' => [
					'type'  => 'text',
					'label' => esc_html__( 'Custom block Classes', 'dlawyers' ),
					'value' => '',
				],
			],
		];

		return $fields;
	}

	public function atbdp_single_listing_content_widgets( $fields ) {

		$fields['dlawyers_bullet_list'] = [
			'options' => [
				'icon' => [
					'type'  => 'icon',
					'label' => esc_html__( 'Icon', 'dlawyers' ),
					'value' => 'la la-align-center',
				],
			],
		];

		$fields['pricing'] = [
			'options' => [
				'icon'  => [
					'type'  => 'icon',
					'label' => esc_html__( 'Icon', 'dlawyers' ),
					'value' => 'uil uil-bill',
				],
				'label' => [
					'type'  => 'text',
					'label' => esc_html__( '', 'dlawyers' ),
					'value' => '',
				],
			],
		];

		$fields['dlawyers_free_consultation'] = [
			'options' => [
				'icon'  => [
					'type'  => 'icon',
					'label' => esc_html__( 'Icon', 'dlawyers' ),
					'value' => 'uil uil-check-circle',
				],
				'label' => [
					'type'  => 'text',
					'label' => esc_html__( '', 'dlawyers' ),
					'value' => '',
				],
			],
		];

		if ( isset( $fields['map'] ) ) {
			unset( $fields['map'] );
		}

		return $fields;
	}

	public function directorist_single_item_template( $template, $data ) {
		if ( 'pricing' === $data['widget_name'] ) {
			$template = Helper::get_template( 'single/fields/pricing', (array) $data );
		}

		return $template;
	}

	public function atbdp_form_preset_widgets( $fields ) {

		$fields['dlawyers_free_consultation'] = [
			'label'   => esc_html__( 'dLawyers: Free Consultation', 'dlawyers' ),
			'icon'    => 'uil uil-check',
			'options' => [
				'type'        => [
					'type'  => 'hidden',
					'value' => 'number',
				],
				'label'       => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Free Consultation', 'dlawyers' ),
				],
				'field_key'   => [
					'type'   => 'meta-key',
					'hidden' => true,
					'value'  => 'dlawyers_free_consultation',
				],
				'placeholder' => [
					'type'  => 'text',
					'label' => esc_html__( 'Placeholder', 'dlawyers' ),
					'value' => esc_html__( 'ex: 20mins', 'dlawyers' ),
				],
				'required'    => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'dlawyers' ),
					'value' => false,
				],
			],
		];

		$fields['dlawyers_age'] = [
			'label'   => esc_html__( 'dLawyers: Age', 'dlawyers' ),
			'icon'    => 'uil uil-0-plus',
			'options' => [
				'type'        => [
					'type'  => 'hidden',
					'value' => 'number',
				],
				'label'       => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Age', 'dlawyers' ),
				],
				'field_key'   => [
					'type'   => 'meta-key',
					'hidden' => true,
					'value'  => 'dlawyers_age',
				],
				'placeholder' => [
					'type'  => 'text',
					'label' => esc_html__( 'Placeholder', 'dlawyers' ),
					'value' => esc_html__( 'ex: 30', 'dlawyers' ),
				],
				'required'    => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'dlawyers' ),
					'value' => false,
				],
			],
		];

		$fields['dlawyers_gender'] = [
			'label'   => esc_html__( 'dLawyers: Gender', 'dlawyers' ),
			'icon'    => 'uil uil-circle',
			'options' => [
				'type'           => [
					'type'  => 'hidden',
					'value' => 'radio',
				],
				'label'          => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => 'Gender',
				],
				'field_key'      => [
					'value' => 'dlawyers_gender',
					'type'  => 'hidden',
					'rules' => [
						'unique'   => true,
						'required' => true,
					],
				],

				'options'        => [
					'type'                 => 'multi-fields',
					'label'                => esc_html__( 'Options', 'dlawyers' ),
					'add-new-button-label' => esc_html__( 'Add Option', 'dlawyers' ),
					'options'              => [
						'option_value' => [
							'type'  => 'text',
							'label' => esc_html__( 'Option Value', 'dlawyers' ),
							'value' => '',
						],
						'option_label' => [
							'type'  => 'text',
							'label' => esc_html__( 'Option Label', 'dlawyers' ),
							'value' => '',
						],
					],
				],
				'description'    => [
					'type'  => 'text',
					'label' => esc_html__( 'Description', 'dlawyers' ),
					'value' => '',
				],
				'required'       => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'dlawyers' ),
					'value' => false,
				],
				'only_for_admin' => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Only For Admin Use', 'dlawyers' ),
					'value' => false,
				],
			],

		];

		return $fields;
	}

	public function atbdp_form_custom_widgets( $fields ) {
		$custom_field_meta_key_field = apply_filters( 'directorist_custom_field_meta_key_field_args', [
			'type'  => 'hidden',
			'label' => esc_html__( 'Key', 'dlawyers' ),
			'value' => 'custom-text',
			'rules' => [
				'unique'   => true,
				'required' => true,
			],
		] );

		$fields['dlawyers_bullet_list'] = [
			'label'   => 'dLawyers: Bullet List',
			'icon'    => 'uil uil-text-fields',
			'options' => [
				'type'           => [
					'type'  => 'hidden',
					'value' => 'textarea',
				],
				'label'          => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => 'Bullet List',
				],
				'field_key'      => array_merge( $custom_field_meta_key_field, [
					'value' => 'custom-bullet-list',
				] ),
				'rows'           => [
					'type'  => 'number',
					'label' => esc_html__( 'Rows', 'dlawyers' ),
					'value' => 8,
				],
				'placeholder'    => [
					'type'  => 'text',
					'label' => esc_html__( 'Placeholder', 'dlawyers' ),
					'value' => esc_html__( 'ex: Board Certified, Texas Board Of Legal Specialization- Family Law', 'dlawyers' ),
				],
				'description'    => [
					'type'  => 'text',
					'label' => esc_html__( 'Description', 'dlawyers' ),
					'value' => esc_html__( 'Each new line will print bullet point', 'dlawyers' ),
				],
				'required'       => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'dlawyers' ),
					'value' => false,
				],
				'only_for_admin' => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Only For Admin Use', 'dlawyers' ),
					'value' => false,
				],

			],

		];

		return $fields;
	}

	public function directorist_search_form_widgets( $fields ) {
		$dlawyers_age = [
			'label'   => esc_html__( 'dLawyers: Age', 'dlawyers' ),
			'icon'    => 'uil uil-0-plus',
			'options' => [
				'label' => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Age', 'dlawyers' ),
				],
			],
		];
		$dlawyers_pricing_slider = [
			'label'   => esc_html__( 'dLawyers: Pricing Slider', 'dlawyers' ),
			'icon'    => 'uil uil-0-plus',
			'options' => [
				'label' => [
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Pricing Slider', 'dlawyers' ),
				],
			],
		];
		$dlawyers_gender = [
			'label'   => esc_html__( 'dLawyers: Gender', 'dlawyers' ),
			'icon'    => 'uil uil-0-plus',
			'options' => [
				'label'    => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Label', 'dlawyers' ),
					'value' => esc_html__( 'Gender', 'dlawyers' ),
				],
				'required' => [
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'dlawyers' ),
					'value' => false,
				],
			],
		];

		$fields['other_widgets']['widgets']['dlawyers_age']            = $dlawyers_age;
		$fields['other_widgets']['widgets']['dlawyers_pricing_slider'] = $dlawyers_pricing_slider;
		$fields['other_widgets']['widgets']['dlawyers_gender']         = $dlawyers_gender;

		return $fields;
	}

	public function directorist_search_field_template( $template, $data ) {

		// if ( 'dlawyers_age' === $data['widget_name'] ) {
		// 	$template = Helper::get_template( 'search-form/fields/dlawyers_age', (array) $data );
		// }

		return $template;
	}

	public function atbdp_search_listings_meta_queries( $query_data ) {

		foreach ( $query_data as $key => $value ) {

			// Age
			if ( isset( $query_data[$key]['key'] ) && '_dlawyers_age' === $query_data[$key]['key'] ) {
				$ages      = explode( 'to', $query_data[$key]['value'] );
				$age_query = [
					'key'     => '_dlawyers_age',
					'value'   => $ages,
					'type'    => 'NUMERIC',
					'compare' => 'BETWEEN',
				];
				$query_data[$key] = $age_query;
			}
		}

		return $query_data;
	}

	public function dlawyers_header_container_class( $class ) {

		if ( atbdp_is_page( 'dashboard' ) ) {
			$class = 'container-fluid';
		}

		return $class;
	}

	public function body_classes( $classes ) {

		$page_list = [
			'home',
			'search-result',
			'add-listing',
			'all-listing',
			'dashboard',
			'author',
			'category',
			'single_category',
			'all_locations',
			'single_location',
			'single_tag',
			'registration',
			'login',
		];

		foreach ( $page_list as $page ) {

			if ( atbdp_is_page( $page ) ) {
				$classes[] = "theme-dir-{$page}";
			}

		}

		if ( is_single() && 'at_biz_dir' === get_post_type() ) {
			$classes[] = "theme-dir-single_listing";
		}

		if ( class_exists( 'BD_Map_View' ) && atbdp_is_page( 'all-listing' ) ) {
			$is_lwm_active = strpos( get_the_content(), 'listings_with_map' );
			$classes[]     = ( $is_lwm_active ) ? 'dir-listings_with_map' : '';
		}

		return $classes;
	}

	public function dlawyers_top_header_menu_area_class( $class ) {

		if ( atbdp_is_page( 'dashboard' ) ) {
			$class .= ' fixed-top dashboard-menu-area';
		}

		if ( ! atbdp_is_page( 'dashboard' ) && Theme::$options['sticky_header'] ) {
			$class .= ' sticky-top';
		}

		return $class;
	}

	public function directorist_js_scripts( $js_list ) {

		foreach ( $js_list as $key => $value ) {

			if ( 'directorist-search-listing' === $key ) {
				unset( $js_list[$key]['section'] );
			}

			if ( 'directorist-search-form-listing' === $key ) {
				unset( $js_list[$key]['section'] );
			}

			if ( 'directorist-range-slider' === $key ) {
				unset( $js_list[$key]['section'] );
			}

		}

		return $js_list;
	}

	public function wp_body_open() {
		DHelper::get_template_part( 'directorist/custom/content-header-login-modal' );
		DHelper::get_template_part( 'directorist/custom/listing-contact' );

		if ( ! atbdp_is_page( 'add_listing' ) && Theme::$options['header_search'] ) {
			DHelper::get_template_part( 'directorist/custom/popup-search' );
		}
	}

	public function directorist_dashboard_listing_th_2() {
		DHelper::get_template_part( 'directorist/custom/dashboard_listing_th_2' );
	}

	public function directorist_dashboard_listing_td_2() {
		DHelper::get_template_part( 'directorist/custom/dashboard_listing_td_2', get_the_ID() );
	}

	public function dlawyers_admin_script( $data ) {
		echo '<script type="text/javascript">';
		ob_start();

		echo DHelper::requires( 'admin.js', 'assets/js' );

		ob_end_flush();
		echo '</script>';
	}

	public function all_listings_pagination_prev_text() {
		return directorist_icon( 'las la-long-arrow-alt-left', false );
	}

	public function all_listings_pagination_next_text() {
		return directorist_icon( 'las la-long-arrow-alt-right', false );
	}

}

Directorist_Support::instance();