<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

Helper::includes( 'dynamic-styles/common.php' );
$typo_body = Theme::$options['typo_body'];
/*--------------
#-CSS Variables
---------------*/
$primary_color = Helper::get_primary_color(); // #ef3072
$primary_rgb   = Helper::hex2rgb( $primary_color ); // 239, 48, 114
$other_colors  = isset( Theme::$options['other_colors'] ) ? Theme::$options['other_colors'] : 'primary_color';
$is_custom     = 'custom' === $other_colors ? true : false;

$menu_text_colors       = Theme::$options['menu_text_colors'];
$menu_color_text        = isset( $menu_text_colors['default'] ) ? $menu_text_colors['default'] : '#000000';
$menu_hover_color_text  = $is_custom && isset( $menu_text_colors['hover'] ) ? $menu_text_colors['hover'] : $primary_color;
$menu_active_color_text = $is_custom && isset( $menu_text_colors['active'] ) ? $menu_text_colors['active'] : $primary_color;

$add_listing_button_text_colors      = Theme::$options['add_listing_button_text_colors'];
$add_listing_button_text_color       = isset( $add_listing_button_text_colors['default'] ) ? $add_listing_button_text_colors['default'] : '#fff';
$add_listing_button_text_color_hover = isset( $add_listing_button_text_colors['hover'] ) ? $add_listing_button_text_colors['hover'] : '#fff';
$add_listing_button_bgcolors         = Theme::$options['add_listing_button_bgcolors'];
$add_listing_button_bgcolor          = $is_custom && isset( $add_listing_button_bgcolors['default'] ) ? $add_listing_button_bgcolors['default'] : $primary_color;
$add_listing_button_bgcolors_hover   = $is_custom && isset( $add_listing_button_bgcolors['hover'] ) ? $add_listing_button_bgcolors['hover'] : $primary_color;

$banner_bgopacity             = isset( Theme::$options['bgopacity'] ) ? Theme::$options['bgopacity'] : '';
$banner_title_color           = isset( Theme::$options['banner_title_color'] ) ? Theme::$options['banner_title_color'] : '#fff';
$breadcrumb_link_colors       = Theme::$options['breadcrumb_link_colors'];
$breadcrumb_link_color        = isset( $breadcrumb_link_colors['default'] ) ? $breadcrumb_link_colors['default'] : '#fff';
$breadcrumb_link_color_hover  = $is_custom && isset( $breadcrumb_link_colors['hover'] ) ? $breadcrumb_link_colors['hover'] : $primary_color;
$breadcrumb_link_color_active = $is_custom && isset( $breadcrumb_link_colors['active'] ) ? $breadcrumb_link_colors['active'] : 'rgba(255, 255, 255, 0.7)';
$breadcrumb_seperator_color   = Theme::$options['breadcrumb_seperator_color'];

$footer_bgcolor       = isset( Theme::$options['footer_bgcolor'] ) ? Theme::$options['footer_bgcolor'] : '#20242F';
$footer_divider_color = isset( Theme::$options['footer_divider_color'] ) ? Theme::$options['footer_divider_color'] : '#ffffff';
$footer_title_color   = isset( Theme::$options['footer_title_color'] ) ? Theme::$options['footer_title_color'] : '#fff';
$footer_text_color    = isset( Theme::$options['footer_text_color'] ) ? Theme::$options['footer_text_color'] : '#cccccc';

$footer_link_colors      = Theme::$options['footer_link_colors'];
$footer_link_color       = isset( $footer_link_colors['default'] ) ? $footer_link_colors['default'] : '#cccccc';
$footer_link_hover_color = $is_custom && isset( $footer_link_colors['hover'] ) ? $footer_link_colors['hover'] : '#ffffff';
?>

<?php
/*--------------
#-CSS Variables
---------------*/
?>

:root {
    --color-primary: <?php echo esc_attr( $primary_color ); ?>;
    --color-primary-rgba: <?php echo esc_attr( $primary_rgb ); ?>;
    --color-primary-rgb-1: rgb(<?php echo esc_attr( $primary_rgb ); ?>, 0.1) ;
    --color-primary-rgb-05: rgb(<?php echo esc_attr( $primary_rgb ); ?>, 0.05);
    --color-primary-rgb-15: rgb(<?php echo esc_attr( $primary_rgb ); ?>, 0.15);

    --color-menu: <?php echo esc_attr( $menu_color_text ); ?>;
    --color-menu-hover: <?php echo esc_attr( $menu_hover_color_text ); ?>;
    --color-menu-active: <?php echo esc_attr( $menu_active_color_text ); ?>;

    --color-add-listing-button-text: <?php echo esc_attr( $add_listing_button_text_color ); ?>;
    --color-add-listing-button-text-hover: <?php echo esc_attr( $add_listing_button_text_color_hover ); ?>;
    --bgcolor-add-listing-button: <?php echo esc_attr( $add_listing_button_bgcolor ); ?>;
    --bgcolor-add-listing-button-hover: <?php echo esc_attr( $add_listing_button_bgcolors_hover ); ?>;

    --banner-bg-opacity: <?php echo esc_attr( $banner_bgopacity ); ?>;
    --color-banner_title: <?php echo esc_attr( $banner_title_color ); ?>;
    --color-breadcrumb-link: <?php echo esc_attr( $breadcrumb_link_color ); ?>;
    --color-breadcrumb-link-hover: <?php echo esc_attr( $breadcrumb_link_color_hover ); ?>;
    --color-breadcrumb-active: <?php echo esc_attr( $breadcrumb_link_color_active ); ?>;
    --color-breadcrumb_separator: <?php echo esc_attr( $breadcrumb_seperator_color ); ?>;

    --bgcolor-footer: <?php echo esc_attr( $footer_bgcolor ); ?>;
    --color-footer-divider: <?php echo esc_attr( $footer_divider_color ); ?>;
    --color-footer-title: <?php echo esc_attr( $footer_title_color ); ?>;
    --color-footer-text: <?php echo esc_attr( $footer_text_color ); ?>;
    --color-footer-link: <?php echo esc_attr( $footer_link_color ); ?>;
    --color-footer-link-hover: <?php echo esc_attr( $footer_link_hover_color ); ?>;

	--theme-angle-down-solid: url(<?php echo Helper::get_svg_icon('angle-down-solid', true); ?>);
    --theme-angle-up-solid: url(<?php echo Helper::get_svg_icon('angle-up-solid', true); ?>);
    --theme-angle-left-solid: url(<?php echo Helper::get_svg_icon('angle-left-solid', true); ?>);
    --theme-angle-right-solid: url(<?php echo Helper::get_svg_icon('angle-right-solid', true); ?>);
    --theme-facebook: url(<?php echo Helper::get_svg_icon('facebook', true); ?>);
    --theme-facebook-square: url(<?php echo Helper::get_svg_icon('facebook-square', true); ?>);
    --theme-twitter: url(<?php echo Helper::get_svg_icon('twitter', true); ?>);
    --theme-times-circle: url(<?php echo Helper::get_svg_icon('times-circle', true); ?>);
    --theme-times-solid: url(<?php echo Helper::get_svg_icon('times-solid', true); ?>);
    --theme-user: url(<?php echo Helper::get_svg_icon('user', true); ?>);
    --theme-instagram: url(<?php echo Helper::get_svg_icon('instagram', true); ?>);
    --theme-paper-plane: url(<?php echo Helper::get_svg_icon('paper-plane', true); ?>);
    --theme-paper-plane-solid: url(<?php echo Helper::get_svg_icon('paper-plane-solid', true); ?>);
    --theme-pinterest: url(<?php echo Helper::get_svg_icon('pinterest', true); ?>);
    --theme-plus-solid: url(<?php echo Helper::get_svg_icon('plus-solid', true); ?>);
    --theme-plus-circle-solid: url(<?php echo Helper::get_svg_icon('plus-circle-solid', true); ?>);
    --theme-rss-solid: url(<?php echo Helper::get_svg_icon('rss-solid', true); ?>);
    --theme-search-solid: url(<?php echo Helper::get_svg_icon('search-solid', true); ?>);
    --theme-vimeo: url(<?php echo Helper::get_svg_icon('vimeo', true); ?>);
    --theme-user-circle: url(<?php echo Helper::get_svg_icon('user-circle', true); ?>);
    --theme-linkedin-in: url(<?php echo Helper::get_svg_icon('linkedin-in', true); ?>);
    --theme-link-solid: url(<?php echo Helper::get_svg_icon('link-solid', true); ?>);
    --theme-vk: url(<?php echo Helper::get_svg_icon('vk', true); ?>);
    --theme-tumblr: url(<?php echo Helper::get_svg_icon('tumblr', true); ?>);
    --theme-github: url(<?php echo Helper::get_svg_icon('github', true); ?>);
    --theme-reddit: url(<?php echo Helper::get_svg_icon('reddit', true); ?>);
    --theme-bars-solid: url(<?php echo Helper::get_svg_icon('bars-solid', true); ?>);
    --theme-youtube: url(<?php echo Helper::get_svg_icon('youtube', true); ?>);
    --theme-reply-solid: url(<?php echo Helper::get_svg_icon('reply-solid', true); ?>);
    --theme-edit: url(<?php echo Helper::get_svg_icon('edit', true); ?>);
    --theme-star-solid: url(<?php echo Helper::get_svg_icon('star-solid', true); ?>);
    --theme-star-half-alt-solid: url(<?php echo Helper::get_svg_icon('star-half-alt-solid', true); ?>);
    --theme-star-empty: url(<?php echo Helper::get_svg_icon('star-empty', true); ?>);
    --theme-check-solid: url(<?php echo Helper::get_svg_icon('check-solid', true); ?>);
    --theme-minus-solid: url(<?php echo Helper::get_svg_icon('minus-solid', true); ?>);
    --theme-quote-left-solid: url(<?php echo Helper::get_svg_icon('quote-left-solid', true); ?>);
    --theme-quote-right-solid: url(<?php echo Helper::get_svg_icon('quote-right-solid', true); ?>);
    --theme-envelope: url(<?php echo Helper::get_svg_icon('envelope', true); ?>);
    <?php if( class_exists( 'HelpGent' ) ) : ?>
        --helpgent-color-primary: var(--color-primary);
        --helpgent-color-secondary: var(--color-secondary);
        --helpgent-color-bg-light: var(--color-bg-light);
        --helpgent-color-gray: var(--color-gray);
        --helpgent-color-light-gray: var(--color-light-gray);
        --helpgent-color-extra-light: var(--color-lighter);
        --helpgent-color-info: var(--color-info);
        --helpgent-color-danger: var(--color-danger);
        --helpgent-color-warning: var(--color-warning);
        --helpgent-color-success: var(--color-success);
        --helpgent-color-text: var(--color-body);
        --helpgent-color-black: var(--color-dark);
        --helpgent-font-family: var(--font-family-body);
        --helpgent-primary-button-bg: var(--color-primary);
        --helpgent-secondary-button-bg: var(--color-secondary);
        --helpgent-color-border-light: var(--color-border-light);
        --helpgent-color-facebook: var(--color-facebook);
        --helpgent-color-twitter: var(--color-twitter);
        --helpgent-color-youtube: var(--color-youtube);
        --helpgent-color-instagram: var(--color-instagram);
        --helpgent-color-dark: var(--color-dark);
        --helpgent-color-bg-general: var(--color-bg-normal);
    <?php endif;?>
}