<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

if ( ! class_exists( 'CSF' ) ) {
	return;
}

use \CSF;

$prefix = Constants::$theme_options . '_layout_settings_page';

// Create a metabox
CSF::createMetabox( $prefix, array(
	'title'     => 'Layout Settings',
	'post_type' => 'page',
	'context'   => 'side',
) );

// Create a section
CSF::createSection(
	$prefix,
	array(
		'fields' => array(
			array(
				'id'      => $prefix . '_container_layout',
				'type'    => 'select',
				'title'   => esc_html__( 'Container Layout', 'dlawyers' ),
				'options' => array(
					'default'         => esc_html__( 'Default', 'dlawyers' ),
					'container'       => esc_html__( 'Container', 'dlawyers' ),
					'container-fluid' => esc_html__( 'Container Fluid', 'dlawyers' ),
				),
				'default' => 'default',
			),
			array(
				'id'      => $prefix . '_layout',
				'type'    => 'select',
				'title'   => esc_html__( 'Sidebar Layout', 'dlawyers' ),
				'options' => array(
					'default'       => esc_html__( 'Default', 'dlawyers' ),
					'left-sidebar'  => esc_html__( 'Left Sidebar', 'dlawyers' ),
					'full-width'    => esc_html__( 'No Sidebar', 'dlawyers' ),
					'right-sidebar' => esc_html__( 'Right Sidebar', 'dlawyers' ),
				),
				'default' => 'default',
			),
			array(
				'id'      => $prefix . '_banner',
				'type'    => 'select',
				'title'   => esc_html__( 'Banner', 'dlawyers' ),
				'options' => array(
					'default' => esc_html__( 'Default', 'dlawyers' ),
					'on'      => esc_html__( 'Enabled', 'dlawyers' ),
					'off'     => esc_html__( 'Disabled', 'dlawyers' ),
				),
				'default' => 'default',
			),
			array(
				'id'         => $prefix . '_breadcrumb',
				'type'       => 'select',
				'title'      => esc_html__( 'Breadcrumb', 'dlawyers' ),
				'options'    => array(
					'default' => esc_html__( 'Default', 'dlawyers' ),
					'on'      => esc_html__( 'Enabled', 'dlawyers' ),
					'off'     => esc_html__( 'Disabled', 'dlawyers' ),
				),
				'default'    => 'default',
				'dependency' => array( $prefix . '_banner', '!=', 'off' ),
			),
			array(
				'id'         => $prefix . '_bgtype',
				'type'       => 'select',
				'title'      => esc_html__( 'Banner Background Type', 'dlawyers' ),
				'options'    => array(
					'default' => esc_html__( 'Default', 'dlawyers' ),
					'bgcolor' => esc_html__( 'Background Color', 'dlawyers' ),
					'bgimg'   => esc_html__( 'Background Image', 'dlawyers' ),
				),
				'default'    => 'default',
				'dependency' => array( $prefix . '_banner', '!=', 'off' ),
			),
			array(
				'id'         => $prefix . '_bgimg',
				'type'       => 'media',
				'title'      => esc_html__( 'Banner Background Image', 'dlawyers' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( $prefix . '_bgtype', '==', 'bgimg' ),
			),
			array(
				'id'          => $prefix . '_bgcolor',
				'type'        => 'color',
				'title'       => esc_html__( 'Banner Background Color', 'dlawyers' ),
				'validate'    => 'color',
				'transparent' => false,
				'default'     => '',
				'dependency'  => array( $prefix . '_bgtype', '==', 'bgcolor' ),
			),
		),
	)
);