<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Colors', 'dlawyers' ),
		'icon'   => 'fas fa-paint-brush',
		'fields' => array(
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Sitewide Colors', 'dlawyers' ),
			),
			array(
				'id'          => 'primary_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Primary Color', 'dlawyers' ),
				'default'     => '#ef3072',
			),
			array(
				'id'          => 'other_colors',
				'type'        => 'button_set',
				'transparent' => false,
				'title'       => esc_html__( 'Other Colors', 'dlawyers' ),
				'options'     => array(
					'primary_color' => esc_html__( 'Primary Color', 'dlawyers' ),
					'custom'        => esc_html__( 'Custom', 'dlawyers' ),
				),
				'desc'        => esc_html__( 'Selecting Primary Color will hide some color options from the below settings and replace them with Primary color', 'dlawyers' ),
				'default'     => 'primary_color',
			),
			array(
				'id'         => 'section-color-menu',
				'type'       => 'heading',
				'title'      => esc_html__( 'Main Menu', 'dlawyers' ),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'menu_text_colors',
				'type'       => 'color_group',
				'title'      => esc_html__( 'Main Menu Text', 'dlawyers' ),
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
					'active'  => 'Active',
				),
				'default'    => array(
					'default' => '#000000',
					'hover'   => '#ef3072',
					'active'  => '#ef3072',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Banner Area', 'dlawyers' ),
			),
			array(
				'id'      => 'banner_title_color',
				'type'    => 'color',
				'title'   => esc_html__( 'Banner Title', 'dlawyers' ),
				'default' => '#ffffff',
			),
			array(
				'id'      => 'breadcrumb_seperator_color',
				'type'    => 'color',
				'title'   => esc_html__( 'Breadcrumb Seperator', 'dlawyers' ),
				'default' => '#f9f9fa',
			),
			array(
				'id'         => 'breadcrumb_link_colors',
				'type'       => 'color_group',
				'title'      => esc_html__( 'Breadcrumb Link', 'dlawyers' ),
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
					'active'  => 'Active',
				),
				'default'    => array(
					'default' => '#f9f9fa',
					'hover'   => '#ef3072',
					'active'  => 'rgba(255, 255, 255, 0.7)',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),

			array(
				'type'       => 'heading',
				'title'      => esc_html__( 'Add Listing Button', 'dlawyers' ),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'add_listing_button_text_colors',
				'title'      => esc_html__( 'Button Text', 'dlawyers' ),
				'type'       => 'color_group',
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default'    => array(
					'default' => '#ffffff',
					'hover'   => '#ffffff',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),
			array(
				'id'         => 'add_listing_button_bgcolors',
				'title'      => esc_html__( 'Button Background', 'dlawyers' ),
				'type'       => 'color_group',
				'options'    => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default'    => array(
					'default' => '#ef3072',
					'hover'   => '#000000',
				),
				'dependency' => array( 'other_colors', '==', 'custom' ),
			),

			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Footer Area', 'dlawyers' ),
			),
			array(
				'id'          => 'footer_bgcolor',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Background', 'dlawyers' ),
				'default'     => '#0e1017',
			),
			array(
				'id'          => 'footer_divider_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Divider', 'dlawyers' ),
				'default'     => 'rgba(255,255,255,0.05)',
			),
			array(
				'id'          => 'footer_title_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Title', 'dlawyers' ),
				'default'     => 'rgba(255,255,255,0.9)',
			),
			array(
				'id'          => 'footer_text_color',
				'type'        => 'color',
				'transparent' => false,
				'title'       => esc_html__( 'Footer Text', 'dlawyers' ),
				'default'     => 'rgba(255,255,255,0.4)',
			),
			array(
				'id'      => 'footer_link_colors',
				'type'    => 'color_group',
				'title'   => esc_html__( 'Footer Link', 'dlawyers' ),
				'options' => array(
					'default' => 'Default',
					'hover'   => 'Hover',
				),
				'default' => array(
					'default' => 'rgba(255,255,255,0.4)',
					'hover'   => '#ffffff',
				),
			),
		),
	)
);