<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Directorist Settings', 'dlawyers' ),
		'icon'   => 'fas fa-th-large',
		'fields' => array(

			// Dashboard
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Dashboard', 'dlawyers' ),
			),
			array(
				'id'      => 'dashboard_show_average_rating',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show Average Rating?', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'dashboard_show_category',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show Category?', 'dlawyers' ),
				'default' => true,
			),

			// Pricing Plans
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Pricing Plans', 'dlawyers' ),
			),
			array(
				'id'      => 'show_plan_type',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show Plan Type', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'select_plan_button_text',
				'type'    => 'text',
				'title'   => esc_html__( 'Select Plan Button Text', 'dlawyers' ),
				'default' => esc_html__( "Select Plan", 'dlawyers' ),
			),

			// Listings Card List Layout With Preview Image
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'List view with thumbnail', 'dlawyers' ),
			),
			array(
				'id'      => 'show_free_consultation',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show Free Consultation', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'free_consultation_text',
				'type'       => 'text',
				'title'      => esc_html__( 'Text', 'dlawyers' ),
				'default'    => esc_html__( "Free Consultation", 'dlawyers' ),
				'dependency' => array( 'show_free_consultation', '==', true ),

			),
			array(
				'id'         => 'free_consultation_icon',
				'type'       => 'text',
				'title'      => esc_html__( 'Icon', 'dlawyers' ),
				'default'    => esc_html__( "uil uil-check", 'dlawyers' ),
				'dependency' => array( 'show_free_consultation', '==', true ),

			),

			// All Categories Page
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'All Categories', 'dlawyers' ),
			),
			array(
				'id'      => 'show_all_categories_title',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show All Categories Title', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'all_categories_title_text_1',
				'type'       => 'text',
				'title'      => esc_html__( 'Text 1', 'dlawyers' ),
				'default'    => esc_html__( "Search by", 'dlawyers' ),
				'dependency' => array( 'show_all_categories_title', '==', true ),
			),
			array(
				'id'         => 'all_categories_title_text_2',
				'type'       => 'text',
				'title'      => esc_html__( 'Text 2', 'dlawyers' ),
				'default'    => esc_html__( "Specialties", 'dlawyers' ),
				'dependency' => array( 'show_all_categories_title', '==', true ),
			),

			// All Locations Page
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'All Locations', 'dlawyers' ),
			),
			array(
				'id'      => 'show_all_locations_title',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Show All Locations Title', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'all_locations_title_text_1',
				'type'       => 'text',
				'title'      => esc_html__( 'Text 1', 'dlawyers' ),
				'default'    => esc_html__( "Search by", 'dlawyers' ),
				'dependency' => array( 'show_all_locations_title', '==', true ),
			),
			array(
				'id'         => 'all_locations_title_text_2',
				'type'       => 'text',
				'title'      => esc_html__( 'Text 2', 'dlawyers' ),
				'default'    => esc_html__( "Practice area", 'dlawyers' ),
				'dependency' => array( 'show_all_locations_title', '==', true ),
			),

		),
	)
);