<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'General', 'dlawyers' ),
		'icon'   => 'fas fa-globe-asia',
		'fields' => array(
			array(
				'id'      => 'logo',
				'type'    => 'media',
				'title'   => esc_html__( 'Logo', 'dlawyers' ),
				'library' => 'image',
				'url'     => false,
			),
			array(
				'id'      => 'preloader',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Preloader', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'preloader_image',
				'type'       => 'media',
				'title'      => esc_html__( 'Preloader Image', 'dlawyers' ),
				'subtitle'   => esc_html__( 'Please upload your choice of preloader image. Transparent GIF format is recommended', 'dlawyers' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( 'preloader', '==', 'true' ),
			),
		),
	)
);