<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Header', 'dlawyers' ),
		'icon'   => 'fas fa-flag',
		'fields' => array(
			array(
				'id'       => 'resmenu_width',
				'type'     => 'slider',
				'title'    => esc_html__( 'Responsive Header Screen Width', 'dlawyers' ),
				'subtitle' => esc_html__( 'Screen width in which mobile menu activated. Recommended value is: 991', 'dlawyers' ),
				'default'  => 991,
				'min'      => 0,
				'step'     => 1,
				'max'      => 2000,
				'unit'     => 'px',
			),
			array(
				'id'      => 'container_type',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Header Style', 'dlawyers' ),
				'options' => array(
					'container-fluid' => Helper::get_img( 'header-container-fluid.png' ),
					'container'       => Helper::get_img( 'header-container.png' ),
				),
				'default' => 'container',

			),
			array(
				'id'      => 'sticky_header',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Sticky Header', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'header_search',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Header Search', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'header_account',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Header Account', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'add_listing_button',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Add Listing Button', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'add_listing_button_text',
				'type'       => 'text',
				'title'      => esc_html__( 'Add Listing Button Text', 'dlawyers' ),
				'default'    => esc_html__( "Add Lawyer", 'dlawyers' ),
				'dependency' => array( 'add_listing_button', '==', 'true' ),
			),
			array(
				'id'      => 'banner',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Banner', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'breadcrumb',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Breadcrumb', 'dlawyers' ),
				'default'    => true,
				'dependency' => array( 'banner', '==', 'true' ),
			),
			array(
				'id'         => 'bgtype',
				'type'       => 'button_set',
				'title'      => esc_html__( 'Banner Background Type', 'dlawyers' ),
				'options'    => array(
					'bgcolor' => esc_html__( 'Background Color', 'dlawyers' ),
					'bgimg'   => esc_html__( 'Background Image', 'dlawyers' ),
				),
				'default'    => 'bgimg',
				'dependency' => array( 'banner', '==', 'true' ),
			),
			array(
				'id'          => 'bgcolor',
				'type'        => 'color',
				'title'       => esc_html__( 'Banner Background Color', 'dlawyers' ),
				'validate'    => 'color',
				'transparent' => false,
				'default'     => '#f2f2f2',
				'dependency'  => array( 'bgtype', '==', 'bgcolor' ),
			),
			array(
				'id'         => 'bgimg',
				'type'       => 'media',
				'title'      => esc_html__( 'Banner Background Image', 'dlawyers' ),
				'library'    => 'image',
				'url'        => false,
				'dependency' => array( 'bgtype', '==', 'bgimg' ),
			),
			array(
				'id'         => 'bgopacity',
				'type'       => 'slider',
				'title'      => esc_html__( 'Banner Background Opacity', 'dlawyers' ),
				'min'        => 0,
				'max'        => 100,
				'step'       => 1,
				'default'    => 60,
				'unit'       => '%',
				'dependency' => array( 'bgtype', '==', 'bgimg' ),
			),
		),
	)
);