<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

function wpwaxtheme_csf_post_type_fields( $prefix ) {
	return array(
		'container_layout' => array(
			'id'      => $prefix . '_container_layout',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Container Layout', 'dlawyers' ),
			'options' => array(
				'container'       => esc_html__( 'Container', 'dlawyers' ),
				'container-fluid' => esc_html__( 'Container Fluid', 'dlawyers' ),
			),
			'default' => 'container',
		),
		'layout'           => array(
			'id'      => $prefix . '_layout',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Sidebar Layout', 'dlawyers' ),
			'options' => array(
				'left-sidebar'  => esc_html__( 'Left Sidebar', 'dlawyers' ),
				'full-width'    => esc_html__( 'No Sidebar', 'dlawyers' ),
				'right-sidebar' => esc_html__( 'Right Sidebar', 'dlawyers' ),
			),
			'default' => 'right-sidebar',
		),
		'banner'           => array(
			'id'      => $prefix . '_banner',
			'type'    => 'select',
			'title'   => esc_html__( 'Banner', 'dlawyers' ),
			'options' => array(
				'default' => esc_html__( 'Default', 'dlawyers' ),
				'on'      => esc_html__( 'Enabled', 'dlawyers' ),
				'off'     => esc_html__( 'Disabled', 'dlawyers' ),
			),
			'default' => 'default',
		),
		'breadcrumb'       => array(
			'id'         => $prefix . '_breadcrumb',
			'type'       => 'select',
			'title'      => esc_html__( 'Breadcrumb', 'dlawyers' ),
			'options'    => array(
				'default' => esc_html__( 'Default', 'dlawyers' ),
				'on'      => esc_html__( 'Enabled', 'dlawyers' ),
				'off'     => esc_html__( 'Disabled', 'dlawyers' ),
			),
			'default'    => 'default',
			'dependency' => array( $prefix . '_banner', '!=', 'off' ),
		),
		'bgtype'           => array(
			'id'         => $prefix . '_bgtype',
			'type'       => 'select',
			'title'      => esc_html__( 'Banner Background Type', 'dlawyers' ),
			'options'    => array(
				'default' => esc_html__( 'Default', 'dlawyers' ),
				'bgcolor' => esc_html__( 'Background Color', 'dlawyers' ),
				'bgimg'   => esc_html__( 'Background Image', 'dlawyers' ),
			),
			'default'    => 'default',
			'dependency' => array( $prefix . '_banner', '!=', 'off' ),
		),
		'bgimg'            => array(
			'id'         => $prefix . '_bgimg',
			'type'       => 'media',
			'title'      => esc_html__( 'Banner Background Image', 'dlawyers' ),
			'library'    => 'image',
			'url'        => false,
			'dependency' => array( $prefix . '_bgtype', '==', 'bgimg' ),
		),
		'bgcolor'          => array(
			'id'          => $prefix . '_bgcolor',
			'type'        => 'color',
			'title'       => esc_html__( 'Banner Background Color', 'dlawyers' ),
			'validate'    => 'color',
			'transparent' => false,
			'default'     => '',
			'dependency'  => array( $prefix . '_bgtype', '==', 'bgcolor' ),
		),
	);
}

\CSF::createSection( $opt_name,
	array(
		'title' => esc_html__( 'Layout Settings', 'dlawyers' ),
		'id'    => 'layout_defaults',
		'icon'  => 'fas fa-th-large',
	)
);

// Page
$wpwaxtheme_page_fields                      = wpwaxtheme_csf_post_type_fields( 'page' );
$wpwaxtheme_page_fields['layout']['default'] = 'full-width';
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Page', 'dlawyers' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_page_fields,
	)
);

//Post Archive
$wpwaxtheme_post_archive_fields = wpwaxtheme_csf_post_type_fields( 'blog' );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Blog / Archive', 'dlawyers' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_post_archive_fields,
	)
);

// Single Post
$wpwaxtheme_single_post_fields = wpwaxtheme_csf_post_type_fields( 'single_post' );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Post Single', 'dlawyers' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_single_post_fields,
	)
);

// Search
$wpwaxtheme_search_fields = wpwaxtheme_csf_post_type_fields( 'search' );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Search Layout', 'dlawyers' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_search_fields,
	)
);

// Error 404 Layout
$wpwaxtheme_error_fields = wpwaxtheme_csf_post_type_fields( 'error' );
unset( $wpwaxtheme_error_fields['layout'] );
\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Error 404 Layout', 'dlawyers' ),
		'parent' => 'layout_defaults',
		'fields' => $wpwaxtheme_error_fields,
	)
);