<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Post Settings', 'dlawyers' ),
		'icon'   => 'fas fa-edit',
		'fields' => array(
			array(
				'id'      => 'post_date',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Post Date', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_author_name',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Author Name', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_comment_num',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Comment Number', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_cats',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Categories', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_tags',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Tags', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_social',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Social Sharing', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'         => 'post_share',
				'type'       => 'checkbox',
				'class'      => 'redux-custom-inline',
				'title'      => esc_html__( 'Social Sharing Icons', 'dlawyers' ),
				'options'    => array(
					'facebook'  => esc_html__( 'Facebook', 'dlawyers' ),
					'twitter'   => esc_html__( 'Twitter', 'dlawyers' ),
					'linkedin'  => esc_html__( 'Linkedin', 'dlawyers' ),
					'pinterest' => esc_html__( 'Pinterest', 'dlawyers' ),
					'tumblr'    => esc_html__( 'Tumblr', 'dlawyers' ),
					'reddit'    => esc_html__( 'Reddit', 'dlawyers' ),
					'vk'        => esc_html__( 'Vk', 'dlawyers' ),
				),
				'default'    => array(
					'facebook'  => '1',
					'twitter'   => '1',
					'linkedin'  => '1',
					'pinterest' => '1',
					'tumblr'    => '0',
					'reddit'    => '0',
					'vk'        => '0',
				),
				'dependency' => array( 'post_social', '==', true ),
				'default'    => array( 'facebook', 'twitter', 'linkedin' ),
			),
			array(
				'id'      => 'post_about_author',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display About Author', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_pagination',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Previous/Next Post Link', 'dlawyers' ),
				'default' => true,
			),
			array(
				'id'      => 'post_related',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Display Related Posts', 'dlawyers' ),
				'default' => true,
			),
		),
	)
);