<?php
/**
 * @author  WpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

$opt_name = Constants::$theme_options;

\CSF::createSection( $opt_name,
	array(
		'title'  => esc_html__( 'Typography', 'dlawyers' ),
		'icon'   => 'fas fa-font',
		'fields' => array(
			array(
				'id'             => 'typo_body',
				'type'           => 'typography',
				'title'          => esc_html__( 'Body', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'subset'         => false,
				'text_transform' => false,
				'font_style'     => true,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '400',
					'font-size'   => '16',
					'line-height' => '28',
					'font-style'  => 'normal',
				),
			),
			array(
				'id'             => 'typo_h1',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h1', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '34',
					'line-height' => '38',
				),
			),
			array(
				'id'             => 'typo_h2',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h2', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '28',
					'line-height' => '32',
				),
			),
			array(
				'id'             => 'typo_h3',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h3', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '22',
					'line-height' => '28',
				),
			),
			array(
				'id'             => 'typo_h4',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h4', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '20',
					'line-height' => '26',
				),
			),
			array(
				'id'             => 'typo_h5',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h5', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '18',
					'line-height' => '24',
				),
			),
			array(
				'id'             => 'typo_h6',
				'type'           => 'typography',
				'title'          => esc_html__( 'Header h6', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '600',
					'font-size'   => '16',
					'line-height' => '20',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Main Menu Items', 'dlawyers' ),
			),
			array(
				'id'             => 'menu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Menu Font', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '400',
					'font-size'   => '16',
					'line-height' => '26',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Sub Menu Items', 'dlawyers' ),
			),
			array(
				'id'             => 'submenu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Submenu Font', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '400',
					'font-size'   => '14',
					'line-height' => '26',
				),
			),
			array(
				'type'  => 'heading',
				'title' => esc_html__( 'Mobile Menu', 'dlawyers' ),
			),
			array(
				'id'             => 'resmenu_typo',
				'type'           => 'typography',
				'title'          => esc_html__( 'Mobile Menu Font', 'dlawyers' ),
				'text_align'     => false,
				'letter_spacing' => false,
				'color'          => false,
				'word_spacing'   => false,
				'text_transform' => false,
				'subset'         => false,
				'default'        => array(
					'font-family' => 'Poppins',
					'font-weight' => '400',
					'font-size'   => '14',
					'line-height' => '21',
				),
			),
		),
	)
);