<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

use Directorist\Directorist_Listings;
use Directorist\Directorist_Listing_Dashboard;
use Directorist\Directorist_Listing_Search_Form;
use Directorist\Directorist_Listing_Taxonomy;
use wpWax\dLawyers\Helper as dLawyersHelper;
trait Directorist_Helper_Trait {

	function sanitize_listing_form_meta_fields( $meta_data, $posted_data ) {
		$feature_list = directorist_get_listing_form_fields( $posted_data['directory_id'] );

		if ( empty( $feature_list ) ) {
			return $meta_data;
		}

		foreach ( array_keys( $feature_list ) as $key ) {
			if ( $feature_list[$key]['widget_name'] === 'dlawyers_bullet_list' ) {
				$meta_data['_' . $feature_list[$key]['field_key']] = sanitize_textarea_field( $posted_data[$feature_list[$key]['field_key']] );
			}
		}

		return $meta_data;
	}

	// Getting View Mode from URL
	public static function get_view_mode() {

		if ( isset( $_GET['view'] ) && 'list' == $_GET['view'] ) {
			return 'list';
		}

		return 'grid';
	}

	// Column for List and Map View
	public static function get_listing_column() {

		if ( 'list' == self::get_view_mode() ) {
			return array( 'lg-12', 'md-12', 'sm-12' );
		}

		return array( 'lg-4', 'md-4', 'sm-6' );
	}

	// Query Search HTML for Search Result-> Header
	public static function get_search_query_html() {
		$html = '';

		if ( isset( $_GET['q'] ) && '' != $_GET['q'] ) {
			$html .= sprintf( ' %s <span> %s </span>', esc_html__( 'for', 'dlawyers' ), esc_html( $_GET['q'] ) );
		}

		if ( isset( $_GET['address'] ) && '' != $_GET['address'] ) {
			$html .= sprintf( ' %s <span> %s </span>', esc_html__( 'near', 'dlawyers' ), esc_html( $_GET['address'] ) );
		}

		return $html;
	}

	// Getting Listing Type
	public static function get_listing_types() {
		$listing_types = array();
		$args          = array(
			'taxonomy'   => ATBDP_TYPE,
			'hide_empty' => false,
		);

		$all_types = get_terms( $args );

		foreach ( $all_types as $type ) {
			$listing_types[$type->term_id] = array(
				'term' => $type,
				'name' => $type->name,
				'data' => get_term_meta( $type->term_id, 'general_config', true ),
			);
		}

		return $listing_types;
	}

	// Getting Directory Type
	public static function get_directory_type() {
		$listing_types = self::get_listing_types();
		$current       = ! empty( $listing_types ) ? array_key_first( $listing_types ) : '';

		if ( isset( $_REQUEST['directory_type'] ) && ! empty( $_REQUEST['directory_type'] ) ) {
			$current = $_REQUEST['directory_type'];
		} else {
			foreach ( $listing_types as $id => $type ) {
				$is_default = get_term_meta( $id, '_default', true );
				if ( $is_default ) {
					$current = $id;
					break;
				}
			}
		}

		if ( self::$listing_type ) {
			$current = self::$listing_type;
		}
		if ( ! is_numeric( $current ) ) {
			$term    = get_term_by( 'slug', $current, ATBDP_TYPE );
			$current = $term->term_id;
		}

		return (int) $current;
	}

	// Listing Type Slug by Term ID
	public static function get_listing_type_slug( $term_id ) {

		if ( ! empty( $term_id ) ) {
			$term_id = self::get_directory_type();
		}

		$term = get_term( $term_id, ATBDP_TYPE );

		return $term->slug;
	}

	// Search Form for nav, top & sidebar
	public static function get_directorist_search_form( $type, $nav_search = false ) {
		$listing_type_id = self::get_directory_type();

		if ( ! self::$searchform ) {
			self::$searchform = new Directorist_Listing_Search_Form( 'search_form', (int) $listing_type_id );
		}

		if ( $nav_search ) {
			self::$searchform->top_categories = self::$searchform->top_categories();
			self::$searchform->nav_search     = $nav_search;
		}

		return dLawyersHelper::get_template_part( "directorist/custom/search-form-{$type}", self::$searchform );
	}

	// Subterms HTML for Elementor-> All Categories-> Grid View -> Style 2
	public static function get_subterms_html( $taxonomy, $term ) {

		if ( $taxonomy->depth <= 0 ) {
			return;
		}

		$args = array(
			'orderby'      => $taxonomy->orderby,
			'order'        => $taxonomy->order,
			'hide_empty'   => $taxonomy->hide_empty,
			'parent'       => $term->term_id,
			'hierarchical' => false,
		);

		$terms       = get_terms( $taxonomy->tax, $args );
		$html        = '';
		$terms_count = count( $terms );

		if ( $terms_count > 0 ) {

			--$taxonomy->depth;

			$html .= '<ul class="theme-cat-box__child-category">';

			foreach ( $terms as $key => $term ) {

				if ( 2 === $key ) {
					break;
				}

				$count = 0;
				if ( $taxonomy->hide_empty || $taxonomy->show_count ) {
					$count = ( $taxonomy->type == 'category' ) ? atbdp_listings_count_by_category( $term->term_id ) : atbdp_listings_count_by_location( $term->term_id );

					if ( $taxonomy->hide_empty && 0 == $count ) {
						continue;
					}

				}

				if ( ! empty( $_REQUEST['directory_type'] ) ) {
					$directory_type = $_REQUEST['directory_type'];
				} else {
					$directory_type = ( 1 == $taxonomy->directory_type_count ) ? $taxonomy->directory_type[0] : '';
				}

				$permalink = ( $taxonomy->type == 'category' ) ? \ATBDP_Permalink::atbdp_get_category_page( $term, $directory_type ) : \ATBDP_Permalink::atbdp_get_location_page( $term, $directory_type );

				$html .= '<li>';
				$html .= '<a href=" ' . $permalink . ' ">';
				$html .= $term->name;
				$html .= "</a>";
				$html .= $taxonomy->subterms_html( $term );
				$html .= '</li>';
			}

			$html .= '</ul>';
		}

		if ( $terms_count > 2 ) {
			$html .= sprintf( '<span class="card-link"><span>%s</span>%s %s</span>', esc_html__( '+', 'dlawyers' ), $terms_count - 2, esc_html__( 'more', 'dlawyers' ) );
		}

		return apply_filters( 'directorist_category_subterms_html', $html );
	}

	// Using for Directorist-> Custom-> Sort
	public static function get_listings_options() {

		if ( ! self::$listings_options ) {
			self::$listings_options = new Directorist_Listings;
		}

		return self::$listings_options;
	}

	// Single Listing Data for Dashboard-> My Listings
	public static function get_dashboard_single_listing( $id ) {

		// Review and Stars
		$avg_stars_html    = '';
		$review_count_html = '';
		$review_count      = ATBDP()->review->db->count( array( 'post_id' => $id ) );
		$get_average       = ATBDP()->review->get_average( $id );
		$review_count_html = sprintf( _nx( '<span> %s </span> review', '<span> %s </span> reviews', $review_count, 'review count', 'dlawyers' ), $review_count );

		for ( $i = 0; $i < $get_average; $i++ ) {
			$icon = directorist_icon( 'la la-star', false );
			$avg_stars_html .= '<li class="rate_active"> ' . $icon . '</li>';
		}

		for ( $i = 0; $i < 5 - $get_average; $i++ ) {
			$icon = directorist_icon( 'la la-star-o', false );
			$avg_stars_html .= '<li class="rate_inactive"> ' . $icon . '</li>';
		}

		// Get Category
		$listing_cat_obj  = get_the_terms( $id, 'at_biz_dir-category' );
		$listing_cat_name = isset( $listing_cat_obj[0] ) ? $listing_cat_obj[0]->name : '';

		$data['avg_starts_html']   = $avg_stars_html ? $avg_stars_html : '';
		$data['review_count_html'] = $review_count_html ? $review_count_html : '';
		$data['listing_cat_name']  = $listing_cat_name ? $listing_cat_name : ' ';

		return $data;
	}

	// Dashboard Navigation for Header Avatar
	public static function get_dashboard_navigation() {
		$data['dashboard'] = Directorist_Listing_Dashboard::instance();

		return dLawyersHelper::get_template_part( '/directorist/custom/header-dashboard-navigation', $data );
	}

	public static function dashboard_tabs() {

		// Tabs
		$dashboard_tabs   = array();
		$my_listing_tab   = get_directorist_option( 'my_listing_tab', 1 );
		$my_profile_tab   = get_directorist_option( 'my_profile_tab', 1 );
		$fav_listings_tab = get_directorist_option( 'fav_listings_tab', 1 );
		$announcement_tab = get_directorist_option( 'announcement_tab', 1 );

		if ( $my_listing_tab ) {
			$dashboard_tabs['dashboard_my_listings'] = array(
				'title' => get_directorist_option( 'my_listing_tab_text', __( 'My Listing', 'dlawyers' ) ),
				'icon'  => 'la la-list',
			);
		}

		if ( $my_profile_tab ) {
			$dashboard_tabs['dashboard_profile'] = array(
				'title' => get_directorist_option( 'my_profile_tab_text', __( 'My Profile', 'dlawyers' ) ),
				'icon'  => 'la la-user',
			);
		}

		if ( $fav_listings_tab ) {
			$dashboard_tabs['dashboard_fav_listings'] = array(
				'title' => get_directorist_option( 'fav_listings_tab_text', __( 'Favorite Listings', 'dlawyers' ) ),
				'icon'  => 'la la-heart-o',
			);
		}

		if ( $announcement_tab ) {
			$dashboard_tabs['dashboard_announcement'] = array(
				'title' => get_directorist_option( 'announcement_tab_text', __( 'Announcements', 'dlawyers' ) ),
				'icon'  => 'la la-bullhorn',
			);
		}

		return $dashboard_tabs;
	}

	// Header Listing Button
	public static function get_header_listing_button_html() {

		if ( Theme::$options['add_listing_button'] ): ?>

			<li class="theme-header-action__add-listing">

				<a href="<?php echo esc_url( \ATBDP_Permalink::get_add_listing_page_link() ); ?>" class="btn btn-sm btn-primary btn-dlawyers btn-add-lawyer"><span class=" d-none d-lg-block"><?php echo esc_html( Theme::$options['add_listing_button_text'] ); ?></span>
				<?php directorist_icon( 'las la-plus' )?>
			</a>

			</li><?php

		endif;
	}

	// Rating List for: Single Listing-> Section Review
	public static function get_rating_list( $listing ) {
		$post_id_or_object = $listing->id;

		/*RATING RELATED STUFF STARTS*/
		if ( is_array( $post_id_or_object ) ) {
			$ratings = $post_id_or_object; // if it is an array of ratings than
		} elseif ( is_numeric( $post_id_or_object ) ) {
			$ratings = ATBDP()->review->db->count( array( 'post_id' => $post_id_or_object ) ); // get only 3
		} else {
			$ratings = array();
		}

		$total_ratings = array(
			5 => 0,
			4 => 0,
			3 => 0,
			2 => 0,
			1 => 0,
		);

		// Find the count of the stars for this post's review
		if ( ! empty( $ratings ) ) {
			foreach ( $ratings as $rating ) {
				if ( is_object( $rating ) ) {
					switch ( $rating->rating ) {
						case (string) 5:
							$total_ratings[5]++; // how many 5 stars we have got?
							break;
						case (string) 4:
							$total_ratings[4]++; // how many 4 stars we have got?
							break;
						case (string) 3:
							$total_ratings[3]++; // how many 3 stars we have got?
							break;
						case (string) 2:
							$total_ratings[2]++; // how many 1 stars we have got?
							break;
						case (string) 1:
							$total_ratings[1]++; // how many 1 star we have got?
							break;
					}
				}
			}
		}

		return $total_ratings;

	}

	// Percentage for: Single Listing-> Section Review
	public static function get_percentage( $count, $percentage ) {

		if ( 0 == $count ) {
			return "0%";
		}

		$percent = $percentage / $count;

		return number_format( $percent * 100 ) . '%';
	}

	// Rating Stars for Single Listing-> Header, Section Review
	public static function get_rating_stars_html( $avg_rating ) {

		$avg_rating = round( $avg_rating, 1 );

		ob_start();?>

		<ul class="ratings" data-rating="<?php echo esc_attr( $avg_rating ); ?>">
			<li class="rating__item"></li>
			<li class="rating__item"></li>
			<li class="rating__item"></li>
			<li class="rating__item"></li>
			<li class="rating__item"></li>
		</ul>

		<?php echo ob_get_clean();
	}

	// Symbol for Search Form-> Pricing Slider & Single Listing-> Section Rates
	public static function get_currency_symbol() {
		$currency = atbdp_get_payment_currency();

		return atbdp_currency_symbol( $currency );
	}

	// Max for Search Form-> Pricing Slider
	public static function get_max_price( $dir_type ) {
		
		$post = get_posts(
			array(
				'post_type'      => ATBDP_POST_TYPE,
				'post_status'    => 'publish',
				'posts_per_page' => -1,
				'fields'         => 'ids',
				'meta_query'     => array(
                    'key'     => '_directory_type',
                    'value'   => $dir_type,
                    'compare' => '=',
				),
                'meta_key' => '_price',
                'orderby'  => 'meta_value_num',
                'order'    => 'DESC',
			)
		);

		$id = isset( $post[0] ) ? $post[0] : '';

		return get_post_meta( $id, '_price', true );
	}

	// Free Consultation Text for List View
	public static function get_free_consultation_html( $listing_id ) {
		$meta_value             = get_post_meta( $listing_id, "_dlawyers_free_consultation", true );
		$show_free_consultation = isset( Theme::$options['show_free_consultation'] ) ? Theme::$options['show_free_consultation'] : false;

		if ( ! $meta_value ) {
			return;
		}

		if ( ! $show_free_consultation ) {
			return;
		}

		$text = isset( Theme::$options['free_consultation_text'] ) ? Theme::$options['free_consultation_text'] : esc_html__( 'Free Consultation', 'dlawyers' );
		$icon = isset( Theme::$options['free_consultation_icon'] ) ? Theme::$options['free_consultation_icon'] : esc_html__( 'uil uil-check', 'dlawyers' );

		printf( '<div class="directorist-listing-card-checkbox">%s%s</div>', directorist_icon( $icon, false ), $text );
	}

	// Content Header
	public static function get_directorist_banner() {

		// page => shortcode
		$dir_page_list = array(
			'search_listing'       => 'directorist_search_listing',
			'search_result_page'   => 'directorist_search_result',
			'all_listing_page'     => 'directorist_all_listing',
			'all_categories_page'  => 'directorist_all_categories',
			'single_category_page' => 'directorist_category',
			'all_locations_page'   => 'directorist_all_locations',
			'single_location_page' => 'directorist_location',
			'single_tag_page'      => 'directorist_tag',
		);

		foreach ( $dir_page_list as $page => $shortcode ) {

			if ( is_page() && get_the_ID() === get_directorist_option( $page ) ) {
				dLawyersHelper::get_template_part( 'directorist/custom/header' );

				return true;
			}

		}

		if ( is_singular( 'at_biz_dir' ) ) {
			dLawyersHelper::get_template_part( 'directorist/custom/header' );

			return true;
		}

		if ( atbdp_is_page( 'author' ) || atbdp_is_page( 'dashboard' ) ) {
			return true;
		}
	}

	// Add Listing/Submission Form Fields Data
	public static function get_submission_form_fields( $directory_type_id = false ) {
		if ( $directory_type_id ) {
			return get_term_meta( $directory_type_id, 'submission_form_fields', true );
		}

		return get_term_meta( self::get_directory_type(), 'submission_form_fields', true );
	}

	// Sidebar Filter on these pages
	public static function show_sidebar_filter( $page_id ) {
		if ( in_array(
			$page_id,
			array(
				get_directorist_option( 'all_locations_page' ),
				get_directorist_option( 'single_category_page' ),
				get_directorist_option( 'all_listing_page' ),
				get_directorist_option( 'search_result_page' ),
				get_directorist_option( 'search_listing' ),
			) ) ) {

			return true;
		}

		return false;
	}

	// Get Single Listing Term Meta
	public static function get_single_listings_contents( $directory_type_id = false ) {
		if ( $directory_type_id ) {
			return get_term_meta( $directory_type_id, 'single_listings_contents', true );
		}

		return get_term_meta( self::get_directory_type(), 'single_listings_contents', true );
	}

	// Single Listing Widget Label for Custom Widgets
	public static function get_single_listing_widget_label( $data ) {
		$single_listings_contents = self::get_single_listings_contents();
		$widget_label             = isset( $single_listings_contents['fields'][$data['widget_name']]['label'] ) ? $single_listings_contents['fields'][$data['widget_name']]['label'] : '';

		if ( empty( $widget_label ) ) {
			$widget_label = $data['label'] ? $data['label'] : '';
		}

		return $widget_label;
	}

	// Taxonomy Custom Template Args for Elementor All Categories-> Grid View -> Style 2
	public static function get_taxonomy_data( $atts ) {
		$taxonomy = new Directorist_Listing_Taxonomy( $atts );

		$args = array(
			'taxonomy'   => $taxonomy,
			'categories' => $taxonomy->tax_data(),
			'columns'    => $taxonomy->columns,
		);

		return $args;
	}

	// Get Active Directory Type Class
	public static function get_directory_type_active_class( $id, $value, $searchform ) {

		if ( isset( $_REQUEST['directory_type'] ) && $value === $_REQUEST['directory_type'] ) {
			return '--current';
		}

		if ( ! isset( $_REQUEST['directory_type'] ) && $searchform->get_default_listing_type() === $id ) {
			return '--current';
		}

		return;
	}

	public static function get_map_view_mode( $object, $mode ) {

		if ( isset( $_POST['view_as'] ) ) {
			$view_as = isset( $_POST['view_as'] ) ? $_POST['view_as'] : '';

			return ( $mode == $view_as ) ? "active" : '';
		}

		foreach ( $object->options as $key => $value ) {
			if ( 'listing_map_view' == $key ) {
				if ( $mode == $value ) {
					return 'active';
				}
			}
		}
	}

	public static function get_map_sort_default_title( $listings, $post_data = array() ) {

		if ( empty( $post_data ) ) {
			return esc_html__( 'Best match', 'dlawyers' );
		}

		foreach ( $post_data as $key => $value ) {
			if ( 'sort_by' == $key ) {
				foreach ( $listings->get_sort_by_link_list() as $_key => $_value ) {
					if ( $_value['key'] == $value ) {
						return ! empty( $_value['label'] ) ? $_value['label'] : esc_html__( 'Best match', 'dlawyers' );
					}
				}
			}
		}
	}

	// Check whether a field has in Basic or Advanced area
	public static function has_field_in_search_form( $field_name, $searchform, $form_type = "basic" ) {
		$basic_or_advance = 'basic' === $form_type ? '0' : '1';

		return isset( $searchform->form_data[$basic_or_advance]['fields'][$field_name] ) ? true : false;
	}

}