<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

trait Socials_Trait {

	public static function socials() {
		$socials = array(
			'social_facebook'  => array(
				'icon' => 'themeicon-facebook-square',
				'url'  => Theme::$options['social_facebook'],
			),
			'social_twitter'   => array(
				'icon' => 'themeicon-twitter',
				'url'  => Theme::$options['social_twitter'],
			),
			'social_linkedin'  => array(
				'icon' => 'themeicon-linkedin-in',
				'url'  => Theme::$options['social_linkedin'],
			),
			'social_youtube'   => array(
				'icon' => 'themeicon-youtube',
				'url'  => Theme::$options['social_youtube'],
			),
			'social_pinterest' => array(
				'icon' => 'themeicon-pinterest',
				'url'  => Theme::$options['social_pinterest'],
			),
			'social_instagram' => array(
				'icon' => 'themeicon-instagram',
				'url'  => Theme::$options['social_instagram'],
			),
			'social_rss'       => array(
				'icon' => 'themeicon-rss-solid',
				'url'  => Theme::$options['social_rss'],
			),
		);
		
		$socials = apply_filters( 'Theme_socials', $socials );

		return array_filter( $socials, array( __CLASS__, 'filter_social' ) );
	}

	public static function user_socials() {
		$socials = array(
			'facebook'  => array(
				'label' => esc_html__( 'Facebook Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-facebook-square',
			),
			'twitter'   => array(
				'label' => esc_html__( 'Twitter Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-twitter',
			),
			'linkedin'  => array(
				'label' => esc_html__( 'Linkedin Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-linkedin-in',
			),
			'github'    => array(
				'label' => esc_html__( 'Github Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-github',
			),
			'youtube'   => array(
				'label' => esc_html__( 'Youtube Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-youtube',
			),
			'pinterest' => array(
				'label' => esc_html__( 'Pinterest Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-pinterest',
			),
			'instagram' => array(
				'label' => esc_html__( 'Instagram Link', 'dlawyers' ),
				'type'  => 'text',
				'icon'  => 'themeicon-instagram',
			),
		);

		return $socials;
	}

	public static function filter_social( $args ) {
		return ( $args['url'] != '' );
	}
}