<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace wpWax\dLawyers;

trait User_Fields_Trait {

	public function user_fields_form( $user ) {
		$user_meta   = get_the_author_meta( 'wpwaxtheme_user_info', $user->ID );
		$designation = isset( $user_meta['designation'] ) ? $user_meta['designation'] : '';
		$socials     = Helper::user_socials();
		?>

		<h2><?php esc_html_e( 'Additional Information', 'dlawyers' ); ?></h2>
		
		<table class="form-table">

			<tbody>

				<?php
				Helper::user_textfield( esc_html__( 'Designation', 'dlawyers' ), 'wpwaxtheme_user_info[designation]', $designation );
				
				foreach ( $socials as $key => $value ) {
					$social = isset( $user_meta['socials'][$key] ) ? $user_meta['socials'][$key] : '';
					Helper::user_textfield( $value['label'], "wpwaxtheme_user_info[socials][$key]", $social );
				}
				?>

			</tbody>

		</table>
		
		<?php
	}

	public function user_fields_update( $user_id = false ) {
		
		if ( ! $user_id ) {
			$user_id = get_current_user_id();
			
			if ( ! $user_id ) {
				return;
			}

		}

		if ( ! current_user_can( 'edit_user', $user_id ) ) {
			return false;
		}

		if ( ! isset( $_POST['wpwaxtheme_user_info'] ) ) {
			return;
		}

		// Sanitize fields
		$meta = $_POST['wpwaxtheme_user_info'];
		
		if ( isset( $meta['designation'] ) ) {
			sanitize_text_field( $meta['designation'] );
		}

		if ( isset( $meta['socials'] ) ) {
			
			foreach ( $meta['socials'] as $key => $value ) {
				$meta['socials'][$key] = sanitize_text_field( $value );
			}
			
		}

		update_user_meta( $user_id, 'wpwaxtheme_user_info', $meta );
	}
}