<?php
/**
 * @author  wpWax
 * @since   1.3
 * @version 1.3
 */

$theme_data = wp_get_theme( get_template() );

// Loads the updater classes
$updater = new Directorist_Theme_Updater_Admin(
	// Config settings
	array(
		'remote_api_url' => 'https://directorist.com', // Site where EDD is hosted
		'item_id'        => 65274, // ID of item in site where EDD is hosted
		'theme_slug'     => 'dlawyers', // Theme slug
		'version'        => $theme_data->get( 'Version' ), // The current version of this theme
		'author'         => $theme_data->get( 'Author' ), // The author of this theme
	),
	// Strings
	array(
		'theme-license'             => __( 'Theme License', 'dlawyers' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'dlawyers' ),
		'license-key'               => __( 'License Key', 'dlawyers' ),
		'license-action'            => __( 'License Action', 'dlawyers' ),
		'deactivate-license'        => __( 'Deactivate License', 'dlawyers' ),
		'activate-license'          => __( 'Activate License', 'dlawyers' ),
		'status-unknown'            => __( 'License status is unknown.', 'dlawyers' ),
		'renew'                     => __( 'Renew?', 'dlawyers' ),
		'unlimited'                 => __( 'unlimited', 'dlawyers' ),
		'license-key-is-active'     => __( 'License key is active.', 'dlawyers' ),
		/* translators: the license expiration date */
		'expires%s'                 => __( 'Expires %s.', 'dlawyers' ),
		'expires-never'             => __( 'Lifetime License.', 'dlawyers' ),
		/* translators: 1. the number of sites activated 2. the total number of activations allowed. */
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'dlawyers' ),
		'activation-limit'          => __( 'Your license key has reached its activation limit.', 'dlawyers' ),
		/* translators: the license expiration date */
		'license-key-expired-%s'    => __( 'License key expired %s.', 'dlawyers' ),
		'license-key-expired'       => __( 'License key has expired.', 'dlawyers' ),
		/* translators: the license expiration date */
		'license-expired-on'        => __( 'Your license key expired on %s.', 'dlawyers' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'dlawyers' ),
		'license-is-inactive'       => __( 'License is inactive.', 'dlawyers' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'dlawyers' ),
		'license-key-invalid'       => __( 'Invalid license.', 'dlawyers' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'dlawyers' ),
		/* translators: the theme name */
		'item-mismatch'             => __( 'This appears to be an invalid license key for %s.', 'dlawyers' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'dlawyers' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'dlawyers' ),
		'error-generic'             => __( 'An error occurred, please try again.', 'dlawyers' ),
	)
);
