<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \wpWax\dLawyers\Helper;
use wpWax\dLawyers\Theme;

if (  class_exists( 'Directorist_Base' ) && ( atbdp_is_page( 'author' ) || ( atbdp_is_page( 'dashboard' ) && is_user_logged_in() ) ) ) {
	Helper::get_template_part( "directorist/custom/directorist-page" );
	
	return;
}

get_header();
?>
<div id="primary" class="content-area">

	<div class="<?php echo esc_attr( Theme::$container_layout ); ?>">

		<div class="row">

			<?php Helper::left_sidebar(); ?>

			<div class="<?php Helper::the_layout_class(); ?>">
				
				<div class="main-content">

					<?php
					while ( have_posts() ){
						the_post();
						get_template_part( 'template-parts/content', 'page' );
						if ( comments_open() || get_comments_number() ){
							comments_template();
						}
					}
					?>

				</div>

			</div>

			<?php Helper::right_sidebar(); ?>

		</div>

	</div>
	
</div>
<?php get_footer(); 