<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \wpWax\dLawyers\Theme;


$post = get_post();
$post = empty( $post->post_content ) ? '' : $post->post_content;

// Return if is elementor footer.
if ( ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'footer' ) ) ) {
	return;
}

// Return is listings with map page.
$is_LWM = class_exists( 'BD_Map_View' ) && strpos( $post, 'listings_with_map' ) ? true : false;
if ( $is_LWM ) {
	return;
}

$dashboard_widget_area = true;
if ( is_user_logged_in() ) {
	$dashboard_widget_area = class_exists( 'Directorist_Base' ) && atbdp_is_page( 'dashboard' ) ? false : true;
}

$footer_columns = 0;
foreach ( range( 1, 4 ) as $i ) {
	if ( is_active_sidebar( 'footer-' . $i ) ) {
		$footer_columns++;
	}
}

switch ( $footer_columns ) {
	case '1':
		$footer_class = 'col-sm-12 ';
		break;
	case '2':
		$footer_class = 'col-sm-6';
		break;
	case '3':
		$footer_class = 'col-md-4 col-sm-12 ';
		break;
	default:
		$footer_class = 'col-lg-3 col-sm-6';
		break;
}
?>

<footer class="site-footer">
	
	<?php if ( Theme::$options['footer_area'] && $footer_columns && $dashboard_widget_area ): ?>
	
		<div class="footer-top-area">

			<div class="container">

				<div class="row">

					<?php foreach ( range( 1, 4 ) as $i ) :

						if ( ! is_active_sidebar( 'footer-' . $i ) ) {
							continue;
						}
						?>

						<div class="<?php echo esc_attr( $footer_class ); ?>">

							<?php dynamic_sidebar( 'footer-' . $i ); ?>

						</div>

					<?php endforeach; ?>

				</div>

			</div>

		</div>

	<?php endif;?>

	<?php if ( Theme::$options['copyright_area'] ): ?>
		
		<div class="footer-bottom-area">

			<div class="container">

				<div class="row">

					<div class="col-md-12">

						<div class="copyright-text"><?php echo do_shortcode( Theme::$options['copyright_text'] ); ?></div>

					</div>

				</div>

			</div>

		</div>

	<?php endif; ?>

</footer>