<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

$previous    = get_previous_post();
$next        = get_next_post();
$date_format = apply_filters( 'wpwaxtheme_post_pagination_date_format', 'F j, Y' );
?>
<div class="post-pagination">

	<?php if ( $previous ): ?>

		<?php $post_obj = $previous; ?>

		<div class="prev-post">

			<span class="post-pagination-label"><?php esc_html_e( 'Previous Post:', 'dlawyers' ) ?></span>

			<a class="title" href="<?php echo esc_url( get_permalink( $post_obj ) ); ?>"><?php echo get_the_title( $post_obj ); ?></a>

			<p class="post-pagination-meta">
				<span class="post-pagination-time"><a href="<?php echo esc_url( get_permalink( $post_obj ) ); ?>"> <?php echo esc_html( get_post_time( $date_format, false, $post_obj ) ); ?></a></span>
				<span class="post-pagination-sep"><?php esc_html_e( '- In', 'dlawyers' ); ?></span>
				<span class="post-pagination-cats"><?php echo get_the_category_list( ', ', '', $post_obj->ID ); ?></span>
			</p>

		</div>

	<?php endif; ?>

	<?php if ( $next ): ?>

		<?php $post_obj = $next; ?>

		<div class="next-post">

			<span class="post-pagination-label"><?php esc_html_e( 'Next Post:', 'dlawyers' ) ?></span>

			<a class="title" href="<?php echo esc_url( get_permalink( $post_obj ) ); ?>"><?php echo get_the_title( $post_obj ); ?></a>

			<p class="post-pagination-meta">
				<span class="post-pagination-time"><a href="<?php echo esc_url( get_permalink( $post_obj ) ); ?>"> <?php echo esc_html( get_post_time( $date_format, false, $post_obj ) ); ?></a></span>
				<span class="post-pagination-sep"><?php esc_html_e( '- In', 'dlawyers' ); ?></span>
				<span class="post-pagination-cats"><?php echo get_the_category_list( ', ', '', $post_obj->ID ); ?></span>
			</p>

		</div>

	<?php endif; ?>
	
</div>