<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use wpWax\dLawyers\Theme;

$args = array(
	'category__in'        => wp_get_post_categories( $post->ID ),
	'post__not_in'        => array( $post->ID ),
	'numberposts'         => 2,
	'ignore_sticky_posts' => 1,
);

$related = get_posts( $args );
$count   = count( $related );

if ( ! $count ) {
	return;
}

$thumb_size  = 'wpwaxtheme-size2';
$date_format = apply_filters( 'wpwaxtheme_related_post_date_format', 'F j, Y' );
$post_class  = 'col-lg-6 col-sm-6';
?>
<div class="related-post">

	<div class="related-post--title text-center">

		<h3><?php esc_html_e( 'Related Posts', 'dlawyers' ); ?></h3>

	</div>

	<div class="row">

		<?php foreach ( $related as $post_obj ): ?>

			<div class="<?php echo esc_attr( $post_class ); ?>">
				
				<article id="post-<?php the_ID(); ?>" <?php post_class( 'theme-blog-each' ); ?>>

					<?php if ( has_post_thumbnail( $post_obj ) ): ?>

						<div class="theme-blog-thumbnail">
							<div class="theme-blog-img">
								<a href="<?php the_permalink(); ?>"><?php echo get_the_post_thumbnail( $post_obj, $thumb_size ); ?></a>
							</div>
						
						</div>

					<?php endif; ?>

					<div class="theme-blog-content-area">

						<div class="theme-blog-content">

							<h4 class="theme-blog-title">
								<a href="<?php echo esc_url( get_permalink( $post_obj ) ); ?>"><?php echo get_the_title( $post_obj ); ?></a>
							</h4>

						</div>

						<div class="theme-blog-meta">

							<div class="theme-blog-meta-list">

								<ul>

									<?php if ( Theme::$options['blog_date'] ): ?>

										<li class="theme-blog-date-meta"><span class="theme-blog-date-meta-text updated published"><?php echo get_post_time( $date_format, false, $post_obj ); ?></span></li>
									
									<?php endif; ?>

									<?php if ( Theme::$options['blog_cats'] && has_category() ): ?>
									
										<li class="theme-blog-category-meta"><span class="theme-blog-category-meta-label"><?php esc_html_e('In', 'dlawyers'); ?></span><?php echo get_the_category_list( ', ', '', $post_obj->ID ); ?></li>
									
									<?php endif; ?>

								</ul>

							</div>

						</div>

					</div>

				</article>

			</div>

		<?php endforeach; ?>

	</div>
	
</div>