<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use \wpWax\dLawyers\Theme;
use \wpWax\dLawyers\Helper;

$thumb_size  	= 'wpwaxtheme-size1';
$author_id	 	= get_the_author_meta( 'ID' );
$author_name 	= get_the_author_meta( 'display_name' );
$author_bio 	= get_the_author_meta( 'description' );
$author_info    = get_the_author_meta( 'wpwaxtheme_user_info' ) ? get_the_author_meta( 'wpwaxtheme_user_info' ) : array();
$author_socials = array();

if ( ! empty( $author_info['socials'] ) ) {
	$socials = Helper::user_socials();

	foreach ( $author_info['socials'] as $key => $value ) {
		
		if ( $value ) {
			$author_socials[$key] = array(
				'icon' => $socials[$key]['icon'],
				'link' => $value,
			);
		}

	}	

}
?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'post-single' ); ?>>

	<div class="post-details">

		<?php if ( has_post_thumbnail() ): ?>

			<figure class="post-thumbnail"><?php the_post_thumbnail( $thumb_size ); ?></figure>

		<?php endif; ?>

		<div class="post-content">

			<div class="post-header">

				<div class="post-meta">

					<ul>
						<?php if ( Theme::$options['post_date'] ): ?>

							<?php printf( '<li><span class="updated published">%s</span></li>', get_the_time( get_option( 'date_format' ) ) ); ?>

						<?php endif; ?>

						<?php if ( Theme::$options['post_author_name'] ): ?>

							<?php printf( '<li>%s <span class="vcard author"><a href="%s" class="fn">%s</a></span></li>', esc_html( 'by', 'dlawyers' ), get_author_posts_url( $author_id ), get_the_author() ); ?>
	
						<?php endif; ?>

						<?php if ( Theme::$options['post_cats'] && has_category() ): ?>

							<li><?php esc_html_e( 'in', 'dlawyers' ); ?> <?php the_category( ', ' ); ?></li>

						<?php endif; ?>

						<?php if ( Theme::$options['post_comment_num'] ): ?>

							<li><?php comments_popup_link( esc_html__( 'No comments yet', 'dlawyers' ), esc_html__( '1 comment', 'dlawyers' ), esc_html__( '% comments', 'dlawyers' ), 'comments-link', esc_html__( 'Comments are off', 'dlawyers' ) ); ?></li>
						
						<?php endif; ?>

					</ul>

				</div>

			</div>

			<div class="post-body">

				<?php the_content(); ?>

			</div>

			<?php 
				wp_link_pages( 
					array( 'before' => '<div class="page-links">',
					'after'  => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>'
					)
				); 
			?>

		</div>

		<div class="post-bottom">

			<?php if ( Theme::$options['post_tags'] && has_tag() ): ?>

				<div class="tags">

					<ul class="d-flex list-unstyled">

						<?php echo get_the_term_list( $post->ID, 'post_tag', '<li>', '</li><li>', '</li>' ); ?>

					</ul>

				</div>

			<?php endif; ?>

			<?php if ( Theme::$options['post_social'] ): ?>

				<?php do_action( 'dlawyers_social_share', Theme::$options['post_social'] ); ?>

			<?php endif; ?>
			
		</div>

	</div>

	<?php if( Theme::$options['post_about_author'] && $author_bio ): ?>

		<div class="post-author theme-border-blog cardify">

			<div class="author-thumb">

				<a href="<?php echo get_author_posts_url( $author_id ); ?>"><?php echo get_avatar( $author_id, 100 ); ?></a>

			</div>

			<div class="author-info">

				<h5 class="author-name"><?php echo esc_html( $author_name ); ?></h5>

				<p class="author-bio"><?php echo wp_kses_post( $author_bio ); ?></p>

				<?php if ( $author_socials ): ?>

					<ul class="list-unstyled social-basic">

						<?php foreach ( $author_socials as $author_social ): ?>

							<li><a href="<?php echo esc_url( $author_social['link'] ); ?>" target="_blank"><i class="themeicon <?php echo esc_attr( $author_social['icon'] ); ?>"></i></a></li>

						<?php endforeach; ?>

					</ul>

				<?php endif; ?>

			</div>

		</div>
	
	<?php endif; ?>

	<?php
	if ( Theme::$options['post_pagination'] ) {
		get_template_part( 'template-parts/content-single-pagination' );
	}

	if ( Theme::$options['post_related'] ) {
		get_template_part( 'template-parts/content-single-related' );
	}	
	?>

</div>